/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.redis.support;

import com.elitescloud.boot.redis.common.CacheKeyGenerator;
import com.elitescloud.boot.redis.common.support.RedisSerializerProvider;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;

public class DefaultRedisSerializerProvider
implements RedisSerializerProvider {
    private final CacheKeyGenerator cacheKeyGenerator;

    public DefaultRedisSerializerProvider(CacheKeyGenerator cacheKeyGenerator) {
        this.cacheKeyGenerator = cacheKeyGenerator;
    }

    @Override
    public RedisSerializer keySerializer() {
        return new RedisSerializer<String>(){
            private final Charset charset = StandardCharsets.UTF_8;

            public String deserialize(byte[] bytes) {
                if (bytes == null) {
                    return null;
                }
                return new String(bytes, this.charset);
            }

            public byte[] serialize(String key) {
                if (key == null) {
                    return new byte[0];
                }
                key = DefaultRedisSerializerProvider.this.cacheKeyGenerator.computeKey(key);
                return key.getBytes(this.charset);
            }
        };
    }

    @Override
    public RedisSerializer valueSerializer() {
        return new JdkSerializationRedisSerializer();
    }

    @Override
    public RedisSerializer hashKeySerializer() {
        return RedisSerializer.string();
    }

    @Override
    public RedisSerializer hashValueSerializer() {
        return new JdkSerializationRedisSerializer();
    }

    @Override
    public RedisSerializer<String> stringSerializer() {
        return RedisSerializer.string();
    }
}

