/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.redis;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.redis.CloudtRedisAutoConfiguration;
import com.elitescloud.boot.redis.CloudtRedisProperties;
import com.elitescloud.boot.redis.redisson.RedissonCustomProperties;
import java.lang.invoke.CallSite;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.spring.cache.CacheConfig;
import org.redisson.spring.cache.RedissonSpringCacheManager;
import org.redisson.spring.data.connection.RedissonConnectionFactory;
import org.redisson.spring.starter.RedissonAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.util.StringUtils;

@ConditionalOnClass(value={Redisson.class})
@ConditionalOnProperty(prefix="elitesland.redis.redisson", name={"enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(value={RedissonAutoConfiguration.class, CloudtRedisAutoConfiguration.class})
class CloudtRedissonAutoConfiguration {
    private static final String REDIS_PROTOCOL_PREFIX = "redis://";
    private static final String REDISS_PROTOCOL_PREFIX = "rediss://";
    private final RedissonCustomProperties redissonCustomProperties;
    private final RedisProperties redisProperties;

    public CloudtRedissonAutoConfiguration(CloudtRedisProperties properties, RedisProperties redisProperties) {
        this.redissonCustomProperties = properties.getRedisson();
        this.redisProperties = redisProperties;
    }

    @Bean(destroyMethod="shutdown")
    @Primary
    public RedissonClient redissonClient() {
        Config config = this.redissonCustomProperties.buildConfig();
        if (config == null) {
            config = this.buildRedissonConfigByRedis();
        }
        return Redisson.create((Config)config);
    }

    @Bean
    public RedisConnectionFactory redisConnectionFactory(RedissonClient redissonClient) {
        return new RedissonConnectionFactory(redissonClient);
    }

    @Bean
    public CacheManager redissonManager(RedissonClient redissonClient, CloudtRedisProperties cloudtRedisProperties) {
        HashMap<CallSite, CacheConfig> configHashedMap = new HashMap<CallSite, CacheConfig>();
        Object prefix = "";
        if (StringUtils.hasText((String)cloudtRedisProperties.getPrefix())) {
            prefix = cloudtRedisProperties.getPrefix() + ":";
        }
        configHashedMap.put((CallSite)((Object)((String)prefix + "longCache")), new CacheConfig(180000L, 120000L));
        configHashedMap.put((CallSite)((Object)((String)prefix + "shortCache")), new CacheConfig(60000L, 30000L));
        return new RedissonSpringCacheManager(redissonClient, configHashedMap);
    }

    private Config buildRedissonConfigByRedis() {
        int timeout = (int)this.obtainTimeout();
        Config config = null;
        if (this.redisProperties.getSentinel() != null) {
            String[] nodes = this.convert(this.redisProperties.getSentinel().getNodes());
            config = new Config();
            ((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)config.useSentinelServers().setMasterName(this.redisProperties.getSentinel().getMaster()).addSentinelAddress(nodes).setDatabase(this.redisProperties.getDatabase()).setConnectTimeout(timeout)).setUsername(CharSequenceUtil.blankToDefault((CharSequence)this.redisProperties.getUsername(), null))).setPassword(CharSequenceUtil.blankToDefault((CharSequence)this.redisProperties.getPassword(), null))).setMasterConnectionMinimumIdleSize(8)).setSlaveConnectionMinimumIdleSize(8);
        } else if (this.redisProperties.getCluster() != null) {
            String[] nodes = this.convert(this.redisProperties.getCluster().getNodes());
            config = new Config();
            ((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)config.useClusterServers().addNodeAddress(nodes).setConnectTimeout(timeout)).setUsername(CharSequenceUtil.blankToDefault((CharSequence)this.redisProperties.getUsername(), null))).setPassword(CharSequenceUtil.blankToDefault((CharSequence)this.redisProperties.getPassword(), null))).setMasterConnectionMinimumIdleSize(8)).setSlaveConnectionMinimumIdleSize(8);
        } else {
            config = new Config();
            String prefix = REDIS_PROTOCOL_PREFIX;
            if (this.redisProperties.isSsl()) {
                prefix = REDISS_PROTOCOL_PREFIX;
            }
            ((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress(prefix + this.redisProperties.getHost() + ":" + this.redisProperties.getPort()).setConnectTimeout(timeout)).setDatabase(this.redisProperties.getDatabase()).setUsername(CharSequenceUtil.blankToDefault((CharSequence)this.redisProperties.getUsername(), null))).setPassword(CharSequenceUtil.blankToDefault((CharSequence)this.redisProperties.getPassword(), null))).setConnectionMinimumIdleSize(8);
        }
        return config;
    }

    private long obtainTimeout() {
        Duration timeoutValue = this.redisProperties.getTimeout();
        return timeoutValue == null ? 10000L : timeoutValue.toMillis();
    }

    private String[] convert(List<String> nodesObject) {
        ArrayList<Object> nodes = new ArrayList<Object>(nodesObject.size());
        for (String node : nodesObject) {
            if (!node.startsWith(REDIS_PROTOCOL_PREFIX) && !node.startsWith(REDISS_PROTOCOL_PREFIX)) {
                nodes.add(REDIS_PROTOCOL_PREFIX + node);
                continue;
            }
            nodes.add(node);
        }
        return nodes.toArray(new String[0]);
    }
}

