/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.redis.support;

import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.redis.common.RedisMessageSubscribe;
import java.io.Serializable;
import org.slf4j.Logger;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.lang.NonNull;

public class RedisMessageDelegate
implements MessageListener {
    private static final Logger logger = CloudtBootLoggerFactory.CACHE_REDIS.getLogger(RedisMessageDelegate.class);
    private final RedisMessageSubscribe delegate;
    private final RedisSerializer<String> channelSerializer;
    private final RedisSerializer<?> valueSerializer;

    public RedisMessageDelegate(RedisMessageSubscribe messageSubscribe, RedisSerializer<String> channelSerializer, RedisSerializer<?> valueSerializer) {
        this.delegate = messageSubscribe;
        this.channelSerializer = channelSerializer;
        this.valueSerializer = valueSerializer;
    }

    public void onMessage(@NonNull Message message, byte[] pattern) {
        try {
            this.handle(message, pattern);
        }
        catch (Throwable throwable) {
            logger.error("\u5904\u7406Redis\u8ba2\u9605\u6d88\u606f\u5f02\u5e38\uff1a", throwable);
        }
    }

    private void handle(Message message, byte[] pattern) {
        String channel = (String)this.channelSerializer.deserialize(pattern);
        logger.info("Received Redis Message:{}", (Object)channel);
        Object obj = this.valueSerializer.deserialize(message.getBody());
        this.delegate.onMessage((Serializable)obj, channel);
    }
}

