package com.elitescloud.boot.security;

import com.elitescloud.boot.provider.CurrentUserProvider;
import com.elitescloud.boot.security.config.CurrentUserExtensionInterceptor;
import com.elitescloud.boot.security.config.CustomSecurityProperties;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.security.CurrentUserExtension;
import com.elitescloud.boot.security.config.FilterInvocationSecurityConfig;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

/**
 * 安全自动化配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/9
 */
@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties({CustomSecurityProperties.class})
@Import({FilterInvocationSecurityConfig.class})
class CloudtSecurityAutoConfiguration {

    /**
     * 当前用户信息
     *
     * @return
     */
    @Bean
    public CurrentUserProvider currentUserProvider() {
        return SecurityContextUtil::currentUser;
    }

    /**
     * 当前扩展用户信息
     *
     * @param userExtensionObjectProvider
     * @return
     */
    @Bean
    public CurrentUserExtensionInterceptor currentUserExtensionInterceptor(ObjectProvider<CurrentUserExtension> userExtensionObjectProvider) {
        return new CurrentUserExtensionInterceptor(userExtensionObjectProvider);
    }
}
