package com.elitescloud.boot.security.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 系统内置角色
 *
 * @author Chris
 * @date 2021-07-09
 */
public enum RoleWhiteListEnum {
    /**
     * 系统管理员角色/系统数据管理员角色
     */
    ADMIN(true, "系统管理员"),
    /**
     * 租户管理员
     */
    TENANT_ADMIN(true, "租户管理员"),

//    /**
//     * 匿名用户角色
//     */
//    ANONYMOUS(true, "匿名用户"),
    ;

    /**
     * 是否启用
     */
    private final boolean enable;

    /**
     * 角色名称
     */
    private final String name;

    RoleWhiteListEnum(boolean enable, String name) {
        this.enable = enable;
        this.name = name;
    }

    public boolean isEnable() {
        return enable;
    }

    public String getName() {
        return name;
    }

    private static final Map<String, RoleWhiteListEnum> ALL = Arrays.stream(RoleWhiteListEnum.values())
            .collect(Collectors.toMap(RoleWhiteListEnum::name, t -> t, (t1, t2) -> t1));

    public static Set<String> getAllCode() {
        return Collections.unmodifiableSet(ALL.keySet());
    }

    public static boolean exists(String roleCode) {
        if (roleCode == null) {
            return false;
        }

        return ALL.containsKey(roleCode.toUpperCase());
    }
}
