package com.elitescloud.boot.security.config;

import com.elitescloud.boot.support.CloudtInterceptor;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.security.CurrentUserExtension;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.NonNull;
import org.springframework.web.util.pattern.PathPattern;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 支持业务扩展当前登录用户信息.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/23
 */
public class CurrentUserExtensionInterceptor implements CloudtInterceptor {

    private final List<PathPattern> excludeRequestMatcher;

    private final CurrentUserExtension userExtension;

    public CurrentUserExtensionInterceptor(ObjectProvider<CurrentUserExtension> userExtensionObjectProvider) {
        this.userExtension = userExtensionObjectProvider.getIfAvailable();
        this.excludeRequestMatcher = createExcludeRequestMatcher();
    }

    @Override
    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        // 判断是否是白名单过滤的
        if (userExtension == null || this.isExclude(request)) {
            return true;
        }

        extensionUserInfo();
        return true;
    }

    private void extensionUserInfo() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null) {
            return;
        }

        Object extension = userExtension.extension(user);
        user.setExtendInfo(extension);
    }

    @Override
    public int order() {
        return 1;
    }

    private boolean isExclude(HttpServletRequest request) {
        if (excludeRequestMatcher.isEmpty()) {
            // 没有白名单
            return false;
        }

        var pathContainer = PathContainer.parsePath(request.getRequestURI());
        return excludeRequestMatcher.stream().anyMatch(t -> t.matches(pathContainer));
    }

    private List<PathPattern> createExcludeRequestMatcher() {
        Set<String> paths = new HashSet<>(CloudtInterceptor.staticResourcePatter());

        return CloudtInterceptor.convert2RequestMatcher(paths);
    }
}
