/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.security.config.metadata;

import com.elitescloud.boot.provider.CurrentUserProvider;
import com.elitescloud.boot.security.common.support.PermissionMetadataProvider;
import com.elitescloud.boot.security.config.CustomSecurityProperties;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.provider.dto.SysApiPermissionMetadataDTO;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

public class CloudtFilterInvocationSecurityMetadataSource
implements FilterInvocationSecurityMetadataSource {
    private static final Logger log = LogManager.getLogger(CloudtFilterInvocationSecurityMetadataSource.class);
    static final String DENIED = "DENIED";
    private final CustomSecurityProperties securityProperties;
    private final CurrentUserProvider currentUserProvider;
    private final PermissionMetadataProvider permissionMetadataProvider;
    private Predicate<HttpServletRequest> allowPredicate = t -> false;
    private boolean anonymous = true;
    private HandlerMappingIntrospector handlerMappingIntrospector = new HandlerMappingIntrospector();
    private final Cache<String, Collection<ConfigAttribute>> requestPermissionCache;
    private final Cache<String, List<SysApiPermissionMetadataDTO>> tenantPermissionRoleCache;

    public CloudtFilterInvocationSecurityMetadataSource(CustomSecurityProperties securityProperties, CurrentUserProvider currentUserProvider, PermissionMetadataProvider permissionMetadataProvider) {
        this.securityProperties = securityProperties;
        this.currentUserProvider = currentUserProvider;
        this.permissionMetadataProvider = permissionMetadataProvider;
        this.requestPermissionCache = Caffeine.newBuilder().maximumSize(500L).expireAfterWrite(securityProperties.getPermissionActionCache()).build();
        this.tenantPermissionRoleCache = Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(securityProperties.getPermissionActionCache()).build();
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        if (!Boolean.TRUE.equals(this.securityProperties.getPermissionEnabled())) {
            return SecurityConfig.createList((String[])new String[0]);
        }
        HttpServletRequest request = ((FilterInvocation)object).getRequest();
        if (this.allowPredicate != null && this.allowPredicate.test(request)) {
            return SecurityConfig.createList((String[])new String[0]);
        }
        GeneralUserDetails currentUser = this.currentUserProvider.currentUser();
        if (currentUser == null && !this.anonymous) {
            return this.decline();
        }
        if (currentUser != null && currentUser.isSystemAdmin()) {
            return SecurityConfig.createList((String[])new String[0]);
        }
        String cacheKey = this.generateCacheKey(currentUser) + ":" + request.getMethod() + ":" + request.getRequestURI();
        Collection<ConfigAttribute> configAttributes = (Collection<ConfigAttribute>)this.requestPermissionCache.getIfPresent((Object)cacheKey);
        if (configAttributes == null) {
            configAttributes = this.queryAttribute(currentUser, request);
            this.requestPermissionCache.put((Object)cacheKey, configAttributes);
        }
        return SecurityConfig.createList((String[])new String[0]);
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return null;
    }

    public boolean supports(Class<?> clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }

    public void setAllowPredicate(Predicate<HttpServletRequest> allowPredicate) {
        this.allowPredicate = allowPredicate;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public void setHandlerMappingIntrospector(HandlerMappingIntrospector handlerMappingIntrospector) {
        this.handlerMappingIntrospector = handlerMappingIntrospector;
    }

    private Collection<ConfigAttribute> decline() {
        return SecurityConfig.createList((String[])new String[]{this.securityProperties.getRolePrefix() + DENIED});
    }

    private Collection<ConfigAttribute> queryAttribute(GeneralUserDetails currentUser, HttpServletRequest request) {
        List<SysApiPermissionMetadataDTO> permissions = this.queryPermissionMetadata(currentUser);
        if (permissions.isEmpty()) {
            return Collections.emptyList();
        }
        return permissions.stream().filter(t -> {
            if (!StringUtils.hasText((String)t.getUri())) {
                return false;
            }
            if (this.securityProperties.isMvcMatcher()) {
                MvcRequestMatcher matcher = new MvcRequestMatcher(this.handlerMappingIntrospector, t.getUri());
                if (StringUtils.hasText((String)t.getMethod())) {
                    matcher.setMethod(HttpMethod.resolve((String)t.getMethod().toUpperCase()));
                }
                return matcher.matches(request);
            }
            AntPathRequestMatcher matcher = new AntPathRequestMatcher(t.getUri(), StringUtils.hasText((String)t.getMethod()) ? t.getMethod().toUpperCase() : null);
            return matcher.matches(request);
        }).flatMap(t -> {
            if (CollectionUtils.isEmpty((Collection)t.getRoleCodes())) {
                return Stream.of(this.securityProperties.getRolePrefix() + DENIED);
            }
            return t.getRoleCodes().stream().map(tt -> this.securityProperties.getRolePrefix() + tt);
        }).distinct().map(SecurityConfig::new).collect(Collectors.toList());
    }

    private List<SysApiPermissionMetadataDTO> queryPermissionMetadata(GeneralUserDetails currentUser) {
        String cacheKey = this.generateCacheKey(currentUser);
        List<Object> permissions = (List<SysApiPermissionMetadataDTO>)this.tenantPermissionRoleCache.getIfPresent((Object)cacheKey);
        if (permissions != null) {
            return permissions;
        }
        permissions = this.permissionMetadataProvider.queryPermissionMetadata(currentUser);
        if (permissions == null) {
            permissions = Collections.emptyList();
        }
        this.tenantPermissionRoleCache.put((Object)cacheKey, permissions);
        return permissions;
    }

    private String generateCacheKey(GeneralUserDetails currentUser) {
        String key = "default";
        if (currentUser != null && currentUser.getTenant() != null) {
            key = currentUser.getTenant().getTenantCode();
        }
        return key;
    }
}

