package com.elitescloud.boot.security;

import com.elitescloud.cloudt.security.common.InnerUserEnum;
import org.springframework.boot.actuate.autoconfigure.security.servlet.EndpointRequest;
import org.springframework.context.annotation.Bean;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.SecurityFilterChain;

/**
 * 指标安全配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/6/2
 */
public class ActuatorSecurityAutoConfiguration {

    @Bean
    public SecurityFilterChain securityFilterChainActuator(HttpSecurity http) throws Exception {
        http.requestMatcher(EndpointRequest.toAnyEndpoint())
                .authorizeHttpRequests(req -> req.anyRequest().access((authentication, object) -> {
                    var auth = authentication.get();
                    if (auth == null || !auth.isAuthenticated()) {
                        return new AuthorizationDecision(false);
                    }
                    return new AuthorizationDecision(InnerUserEnum.ADMIN.getUsername().equals(auth.getName()));
                }));
        return http.build();
    }
}
