package com.elitescloud.boot.security;

import com.elitescloud.boot.provider.UserDetailProvider;
import com.elitescloud.boot.security.config.CurrentUserExtensionInterceptor;
import com.elitescloud.boot.security.config.CustomSecurityProperties;
import com.elitescloud.boot.security.config.FilterInvocationSecurityConfig;
import com.elitescloud.cloudt.security.CurrentUserExtension;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

/**
 * 安全自动化配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/9
 */
@EnableConfigurationProperties({CustomSecurityProperties.class})
@Import({FilterInvocationSecurityConfig.class})
class CloudtSecurityAutoConfiguration {

    /**
     * 当前扩展用户信息
     *
     * @param userExtensionObjectProvider
     * @return
     */
    @Bean
    public CurrentUserExtensionInterceptor currentUserExtensionInterceptor(ObjectProvider<CurrentUserExtension> userExtensionObjectProvider,
                                                                           UserDetailProvider userProvider) {
        return new CurrentUserExtensionInterceptor(userExtensionObjectProvider, userProvider);
    }
}
