package com.elitescloud.boot.security.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 安全相关配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/9
 */
@ConfigurationProperties(prefix = CustomSecurityProperties.CONFIG_PREFIX)
public class CustomSecurityProperties {
    public static final String CONFIG_PREFIX = "elitesland.security";

    /**
     * 是否开启接口权限控制
     */
    private Boolean permissionEnabled = false;

    /**
     * 是否开启数据权限
     */
    private Boolean permissionDataEnabled = false;

    /**
     * 角色前缀
     */
    private String rolePrefix = "ROLE_";

    /**
     * 白名单
     */
    @Deprecated
    private List<WhiteUrl> ignoreUrls = new ArrayList<>();

    /**
     * 忽略的角色
     */
    private Set<String> ignoreRoles = new HashSet<>();

    /**
     * 操作权限缓存时间
     */
    private Duration permissionActionCache = Duration.ofMinutes(30);

    /**
     * 是否使用MVC模式匹配权限
     */
    private boolean mvcMatcher = true;

    public Boolean getPermissionEnabled() {
        return permissionEnabled;
    }

    public void setPermissionEnabled(Boolean permissionEnabled) {
        this.permissionEnabled = permissionEnabled;
    }

    public Boolean getPermissionDataEnabled() {
        return permissionDataEnabled;
    }

    public void setPermissionDataEnabled(Boolean permissionDataEnabled) {
        this.permissionDataEnabled = permissionDataEnabled;
    }

    public String getRolePrefix() {
        return rolePrefix;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    public List<WhiteUrl> getIgnoreUrls() {
        return ignoreUrls;
    }

    public void setIgnoreUrls(List<WhiteUrl> ignoreUrls) {
        this.ignoreUrls = ignoreUrls;
    }

    public Set<String> getIgnoreRoles() {
        return ignoreRoles;
    }

    public void setIgnoreRoles(Set<String> ignoreRoles) {
        this.ignoreRoles = ignoreRoles;
    }

    public Duration getPermissionActionCache() {
        return permissionActionCache;
    }

    public void setPermissionActionCache(Duration permissionActionCache) {
        this.permissionActionCache = permissionActionCache;
    }

    public boolean isMvcMatcher() {
        return mvcMatcher;
    }

    public void setMvcMatcher(boolean mvcMatcher) {
        this.mvcMatcher = mvcMatcher;
    }

    public static class WhiteUrl implements Serializable {
        private static final long serialVersionUID = -1790404970549142902L;

        /**
         * 请求路径
         */
        private String url;

        /**
         * 请求方法
         */
        private String method;

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getMethod() {
            return method;
        }

        public void setMethod(String method) {
            this.method = method;
        }
    }
}
