package com.elitescloud.boot.security.config.metadata;

import com.elitescloud.boot.security.common.RoleWhiteListEnum;
import com.elitescloud.boot.security.config.CustomSecurityProperties;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author Chris
 * @date 2021-07-09
 */
public class CloudtRoleVoter extends RoleVoter {

    /**
     * 角色 白名单
     */
    private final Set<String> whiteRoles = Arrays.stream(RoleWhiteListEnum.values())
            .filter(RoleWhiteListEnum::isEnable)
            .map(role -> super.getRolePrefix() + role.name())
            .collect(Collectors.toSet());

    public CloudtRoleVoter(CustomSecurityProperties customSecurityProperties) {
        if (!CollectionUtils.isEmpty(customSecurityProperties.getIgnoreRoles())) {
            Set<String> roles = customSecurityProperties.getIgnoreRoles().stream()
                    .filter(StringUtils::hasText)
                    .map(role -> super.getRolePrefix() + role)
                    .collect(Collectors.toSet());
            whiteRoles.addAll(roles);
        }
    }


    @Override
    public int vote(Authentication authentication, Object object, Collection<ConfigAttribute> attributes) {
        if (authentication == null) {
            return ACCESS_DENIED;
        }
        int result = ACCESS_ABSTAIN;
        Collection<? extends GrantedAuthority> authorities = extractAuthorities(authentication);

        // 如果拿到的权限为空，则会跳过权限校验
        for (ConfigAttribute attribute : attributes) {
            if (attribute.getAttribute().equals(deniedRole())) {
                return ACCESS_DENIED;
            }

            if (this.supports(attribute)) {
                result = ACCESS_DENIED;

                // Attempt to find a matching granted authority
                for (GrantedAuthority authority : authorities) {
                    // 白名单角色直接放行
                    if (whiteRoles.contains(authority.getAuthority()) || attribute.getAttribute().equals(authority.getAuthority())) {
                        return ACCESS_GRANTED;
                    }
                }
            }
        }

        return result;
    }

    Collection<? extends GrantedAuthority> extractAuthorities(
            Authentication authentication) {
        return authentication.getAuthorities();
    }

    private String deniedRole() {
        return super.getRolePrefix() + CloudtFilterInvocationSecurityMetadataSource.DENIED;
    }
}
