/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.security.config;

import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.security.common.support.PermissionMetadataProvider;
import com.elitescloud.boot.security.config.CustomSecurityProperties;
import com.elitescloud.boot.security.config.metadata.CloudtFilterInvocationSecurityMetadataSource;
import com.elitescloud.boot.security.config.metadata.CloudtRoleVoter;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

@ConditionalOnProperty(prefix="elitesland.security", name={"permission-enabled"}, havingValue="true")
public class FilterInvocationSecurityConfig {
    private static final Logger logger = LoggerFactory.getLogger(FilterInvocationSecurityConfig.class);
    private final AuthorizationProperties authorizationProperties;
    private final CustomSecurityProperties customSecurityProperties;

    public FilterInvocationSecurityConfig(AuthorizationProperties authorizationProperties, CustomSecurityProperties customSecurityProperties) {
        this.authorizationProperties = authorizationProperties;
        this.customSecurityProperties = customSecurityProperties;
    }

    @Bean
    public RoleVoter roleVoter() {
        return new CloudtRoleVoter(this.customSecurityProperties);
    }

    @Bean
    public AccessDecisionManager accessDecisionManager(List<AccessDecisionVoter<?>> decisionVoters) {
        return new AffirmativeBased(decisionVoters);
    }

    @Bean
    @ConditionalOnMissingBean
    public PermissionMetadataProvider permissionMetadataProvider() {
        logger.warn("\u672a\u53d1\u73b0\u6709\u6548\u7684PermissionMetadataProvider");
        return (currentUser, appCodes) -> Collections.emptyList();
    }

    @Bean
    public FilterInvocationSecurityMetadataSource filterInvocationSecurityMetadataSource(CustomSecurityProperties customSecurityProperties, PermissionMetadataProvider permissionMetadataProvider, HandlerMappingIntrospector handlerMappingIntrospector) {
        CloudtFilterInvocationSecurityMetadataSource metadataSource = new CloudtFilterInvocationSecurityMetadataSource(this.authorizationProperties, customSecurityProperties, permissionMetadataProvider, handlerMappingIntrospector);
        metadataSource.setHandlerMappingIntrospector(handlerMappingIntrospector);
        return metadataSource;
    }
}

