/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.security.config.metadata;

import com.elitescloud.boot.security.common.InnerRole;
import com.elitescloud.boot.security.config.CustomSecurityProperties;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.CollectionUtils;

public class CloudtRoleVoter
extends RoleVoter {
    private final Set<String> whiteRoles = new HashSet<String>(8);

    public CloudtRoleVoter(CustomSecurityProperties customSecurityProperties) {
        this.whiteRoles.add(super.getRolePrefix() + InnerRole.SYSTEM_ADMIN.getValue());
        if (!CollectionUtils.isEmpty(customSecurityProperties.getIgnoreRoles())) {
            for (String ignoreRole : customSecurityProperties.getIgnoreRoles()) {
                this.whiteRoles.add(super.getRolePrefix() + ignoreRole);
            }
        }
    }

    public int vote(Authentication authentication, Object object, Collection<ConfigAttribute> attributes) {
        if (authentication == null) {
            return -1;
        }
        int result = 0;
        Collection<? extends GrantedAuthority> authorities = this.extractAuthorities(authentication);
        for (ConfigAttribute attribute : attributes) {
            if (!this.supports(attribute)) continue;
            if (attribute.getAttribute().equals(this.deniedRole())) {
                return -1;
            }
            result = -1;
            for (GrantedAuthority grantedAuthority : authorities) {
                if (!this.whiteRoles.contains(grantedAuthority.getAuthority()) && !attribute.getAttribute().equals(grantedAuthority.getAuthority())) continue;
                return 1;
            }
        }
        return result;
    }

    Collection<? extends GrantedAuthority> extractAuthorities(Authentication authentication) {
        return authentication.getAuthorities();
    }

    private String deniedRole() {
        return super.getRolePrefix() + InnerRole.DENIED.getValue();
    }
}

