/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.binder.segment.select.pagination;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.NumberLiteralPaginationValueSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.PaginationValueSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.ParameterMarkerPaginationValueSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.limit.LimitValueSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PaginationContext {
    private static final Logger log = LoggerFactory.getLogger(PaginationContext.class);
    private final boolean hasPagination;
    private final PaginationValueSegment offsetSegment;
    private final PaginationValueSegment rowCountSegment;
    private final long actualOffset;
    private final Long actualRowCount;

    public PaginationContext(PaginationValueSegment offsetSegment, PaginationValueSegment rowCountSegment, List<Object> parameters) {
        this.hasPagination = null != offsetSegment || null != rowCountSegment;
        this.offsetSegment = offsetSegment;
        this.rowCountSegment = rowCountSegment;
        this.actualOffset = null == offsetSegment ? 0L : this.getValue(offsetSegment, parameters);
        this.actualRowCount = null == rowCountSegment ? null : Long.valueOf(this.getValue(rowCountSegment, parameters));
    }

    private long getValue(PaginationValueSegment paginationValueSegment, List<Object> parameters) {
        if (paginationValueSegment instanceof ParameterMarkerPaginationValueSegment) {
            Object obj = parameters.get(((ParameterMarkerPaginationValueSegment)paginationValueSegment).getParameterIndex());
            if (obj instanceof Long) {
                return (Long)obj;
            }
            try {
                return Long.parseLong(Objects.requireNonNullElse(obj, "0").toString());
            }
            catch (NumberFormatException e) {
                log.error("\u5206\u9875\u53c2\u6570\u5904\u7406bug\uff0c\u53ef\u80fd\u662fsharding\u672c\u8eab\u7684bug\uff0c\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
                return 0L;
            }
        }
        return ((NumberLiteralPaginationValueSegment)paginationValueSegment).getValue();
    }

    public Optional<PaginationValueSegment> getOffsetSegment() {
        return Optional.ofNullable(this.offsetSegment);
    }

    public Optional<PaginationValueSegment> getRowCountSegment() {
        return Optional.ofNullable(this.rowCountSegment);
    }

    public long getActualOffset() {
        if (null == this.offsetSegment) {
            return 0L;
        }
        return this.offsetSegment.isBoundOpened() ? this.actualOffset - 1L : this.actualOffset;
    }

    public Optional<Long> getActualRowCount() {
        return null == this.rowCountSegment ? Optional.empty() : Optional.of(this.rowCountSegment.isBoundOpened() ? this.actualRowCount + 1L : this.actualRowCount);
    }

    public Optional<Integer> getOffsetParameterIndex() {
        return this.offsetSegment instanceof ParameterMarkerPaginationValueSegment ? Optional.of(((ParameterMarkerPaginationValueSegment)this.offsetSegment).getParameterIndex()) : Optional.empty();
    }

    public Optional<Integer> getRowCountParameterIndex() {
        return this.rowCountSegment instanceof ParameterMarkerPaginationValueSegment ? Optional.of(((ParameterMarkerPaginationValueSegment)this.rowCountSegment).getParameterIndex()) : Optional.empty();
    }

    public long getRevisedOffset() {
        return 0L;
    }

    public long getRevisedRowCount(SelectStatementContext shardingStatement) {
        if (this.isMaxRowCount(shardingStatement)) {
            return Integer.MAX_VALUE;
        }
        return this.rowCountSegment instanceof LimitValueSegment ? this.actualOffset + this.actualRowCount : this.actualRowCount;
    }

    private boolean isMaxRowCount(SelectStatementContext shardingStatement) {
        return (!shardingStatement.getGroupByContext().getItems().isEmpty() || !shardingStatement.getProjectionsContext().getAggregationProjections().isEmpty()) && !shardingStatement.isSameGroupByAndOrderByItems();
    }

    @Generated
    public boolean isHasPagination() {
        return this.hasPagination;
    }
}

