package com.elitescloud.boot.spi.strategy;

import com.elitescloud.boot.spi.common.InstanceStrategy;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 默认策略.
 * <p>
 * 所有实例依次执行
 *
 * @author Kaiser（wang shao）
 * @date 3/17/2023
 */
public class DefaultInstanceStrategy implements InstanceStrategy {

    @Override
    public <T> List<T> choose(List<InstanceWrapper<T>> instances) {
        if (CollectionUtils.isEmpty(instances)) {
            return Collections.emptyList();
        }

        return instances.stream()
                .sorted(Comparator.comparingInt(InstanceWrapper::getOrder))
                .map(InstanceWrapper::getInstance)
                .collect(Collectors.toList());
    }
}
