/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.spi.registrar;

import com.elitescloud.boot.spi.common.BaseSpiService;
import com.elitescloud.boot.spi.common.SpiService;
import com.elitescloud.boot.spi.support.SpiServiceProxy;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.Assert;

public class SpiServiceFactory<T extends BaseSpiService<T>>
implements FactoryBean<T> {
    private static final Logger log = LogManager.getLogger(SpiServiceFactory.class);
    private final Class<T> spiService;
    private final SpiService spiServiceAnnotation;
    private final Class<?> spiClass;
    private final List<Class<?>> configSpiInstances;

    public SpiServiceFactory(Class<T> spiService, SpiService spiServiceAnnotation, Map<Class<?>, List<Class<?>>> spiInstances) {
        this.spiService = spiService;
        this.spiServiceAnnotation = spiServiceAnnotation;
        this.spiClass = this.obtainTargetSpiClass();
        this.configSpiInstances = spiInstances.getOrDefault(this.spiClass, Collections.emptyList());
    }

    public T getObject() throws Exception {
        return (T)((BaseSpiService)Proxy.newProxyInstance(this.spiService.getClassLoader(), new Class[]{this.spiService}, new SpiServiceProxy(this.spiServiceAnnotation, this.spiClass, this.configSpiInstances)));
    }

    public Class<?> getObjectType() {
        return this.spiService;
    }

    private Class<?> obtainTargetSpiClass() {
        Object[] types = this.spiService.getGenericInterfaces();
        Assert.notEmpty((Object[])types, (String)("\u672a\u83b7\u53d6\u5230" + this.spiService.getName() + "\u7ee7\u627f\u7684\u63a5\u53e3"));
        for (Object type : types) {
            ParameterizedType parameterizedType;
            if (!(type instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)type).getRawType() != BaseSpiService.class) continue;
            Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
            if (typeArguments != null && typeArguments.length > 0) {
                return (Class)typeArguments[0];
            }
            throw new IllegalStateException(this.spiService.getName() + "\u7684" + BaseSpiService.class.getSimpleName() + "\u672a\u6307\u5b9aSPI\u63a5\u53e3\u7c7b\u578b");
        }
        throw new IllegalStateException(this.spiService.getName() + "\u672a\u7ee7\u627f" + BaseSpiService.class.getSimpleName());
    }
}

