package com.elitescloud.boot.spi.strategy;

import com.elitescloud.boot.spi.common.InstanceStrategy;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 根据配置文件的实例选择策略.
 * </p>
 * <pre>
 *      文件名：CloudtSpi.properties
 *      key：接口的完全限定名称
 *      value：实例的完全限定名称
 * </pre>
 *
 * @author Kaiser（wang shao）
 * @date 3/17/2023
 */
public class ConfigFileInstanceStrategy implements InstanceStrategy {

    @Override
    public <T> List<T> choose(List<InstanceWrapper<T>> instances) {
        if (CollectionUtils.isEmpty(instances)) {
            return Collections.emptyList();
        }
        return instances.stream()
                .filter(InstanceWrapper::isConfigFile)
                .sorted(Comparator.comparingInt(InstanceWrapper::getOrder))
                .map(InstanceWrapper::getInstance)
                .collect(Collectors.toList());
    }
}
