package com.elitescloud.boot.spi.common;

import com.elitescloud.boot.spi.strategy.DefaultInstanceStrategy;

import java.lang.annotation.*;

/**
 * SPI服务注解.
 * <p>
 * 用于继承{@link BaseSpiService}的接口来扩展相关配置
 *
 * @author Kaiser（wang shao）
 * @date 2022/11/10
 */
@Documented
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface SpiService {

    /**
     * bean名称
     * <p>
     * 不设置则自动根据springboot的配置生成
     *
     * @return bean名称
     */
    String beanName() default "";

    /**
     * 默认实例的class名称
     * <p>
     * 当实例选择策略未找到匹配的实例时则执行默认的实例
     *
     * @return class全限定名称
     */
    String[] primary() default {};

    /**
     * 默认实现类
     * <p>
     * 当实例选择策略未找到匹配的实例时则执行默认的实例
     *
     * @return 默认实现类
     */
    Class<?>[] primaryClass() default {};

    /**
     * 默认实现类唯一
     * <p>
     * 当默认不唯一时，将启动检查，如果存在多个则报错
     *
     * @return 是否唯一
     */
    boolean primaryUnique() default true;

    /**
     * 默认实现类是否必须有
     * <p>
     * 如果true，启动时未检测到默认实现将报错
     *
     * @return 是否必须
     */
    boolean primaryRequired() default false;

    /**
     * 当未找到任何可执行实例则抛出异常
     * <p>
     * false时则什么都不执行
     *
     * @return 是否跑异常
     */
    boolean throwExceptionOnNoInstance() default false;

    /**
     * 实例选择策略
     * <p>
     * 必须至少有一个空的构造方法
     *
     * @return 策略
     */
    Class<? extends InstanceStrategy> instanceStrategy() default DefaultInstanceStrategy.class;

    /**
     * 实例选择策略的bean名称
     * <p>
     * 策略必须实现{@link InstanceStrategy}接口，优先级大于{@link #instanceStrategy()}
     *
     * @return bean名称
     */
    String instanceStrategyName() default "";
}
