package com.elitescloud.boot.spi.strategy;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.spi.common.InstanceStrategy;
import com.elitescloud.cloudt.common.annotation.context.spi.SpiInstance;
import com.elitescloud.boot.SpringContextHolder;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 租户的行业实例选择策略.
 * <p>
 * 根据SPI实例上{@link SpiInstance#tags()}过滤
 *
 * @author Kaiser（wang shao）
 * @date 2023/2/2
 */
public class TenantIndustrySpiInstanceStrategy implements InstanceStrategy {
    private TenantClientProvider tenantClientProvider;

    @Override
    public <T> List<T> choose(List<InstanceWrapper<T>> instances) {
        if (instances.isEmpty()) {
            return Collections.emptyList();
        }

        // 获取当前租户
        var tenant = getTenantClientProvider().getSessionTenant();
        if (tenant == null || CharSequenceUtil.isBlank(tenant.getIndustry())) {
            return Collections.emptyList();
        }

        // 根据标签过滤
        return instances.stream()
                .filter(t -> t.getTags() != null && t.getTags().contains(tenant.getIndustry()))
                .map(InstanceWrapper::getInstance)
                .collect(Collectors.toList());
    }

    public TenantClientProvider getTenantClientProvider() {
        if (tenantClientProvider == null) {
            tenantClientProvider = SpringContextHolder.getBean(TenantClientProvider.class);
        }
        return tenantClientProvider;
    }
}
