/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.spi.registrar;

import com.elitescloud.boot.spi.common.BaseSpiService;
import com.elitescloud.boot.spi.common.SpiService;
import com.elitescloud.boot.spi.registrar.SpiServiceFactory;
import com.elitescloud.cloudt.context.util.PropertiesUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.StringUtils;

public class SpiServiceRegistrar
implements ImportBeanDefinitionRegistrar,
BeanFactoryAware,
EnvironmentAware {
    private static final Logger log = LogManager.getLogger(SpiServiceRegistrar.class);
    private static final String PROPERTIES = "META-INF/CloudtSpi.properties";
    private BeanFactory beanFactory;
    private Environment environment;

    public void setBeanFactory(@Nonnull BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setEnvironment(@Nonnull Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(@Nonnull AnnotationMetadata importingClassMetadata, @Nonnull BeanDefinitionRegistry registry, @Nullable BeanNameGenerator importBeanNameGenerator) {
        Set<String> packages = this.obtainScanPackages();
        if (packages.isEmpty()) {
            log.warn("\u672a\u53d1\u73b0\u6709\u6548\u7684SPI\u670d\u52a1\u63a5\u53e3\u7684\u6709\u6548\u5305\u8def\u5f84");
            return;
        }
        Set<BeanDefinition> definitions = this.scanBeanDefinition(packages);
        for (BeanDefinition definition : definitions) {
            Class<?> serviceClass = null;
            try {
                serviceClass = Class.forName(definition.getBeanClassName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            SpiService spiService = serviceClass.getAnnotation(SpiService.class);
            String beanName = this.generateBeanName(definition, spiService);
            registry.registerBeanDefinition(beanName, this.buildBeanDefinition(serviceClass, spiService));
            log.info("\u6ce8\u518cSpiService\uff1a{}", (Object)serviceClass.getName());
        }
    }

    public void registerBeanDefinitions(@Nonnull AnnotationMetadata importingClassMetadata, @Nonnull BeanDefinitionRegistry registry) {
        this.registerBeanDefinitions(importingClassMetadata, registry, null);
    }

    private BeanDefinition buildBeanDefinition(Class<?> serviceClass, SpiService spiService) {
        GenericBeanDefinition beanDefinition = (GenericBeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(serviceClass).getRawBeanDefinition();
        beanDefinition.setBeanClass(SpiServiceFactory.class);
        beanDefinition.getConstructorArgumentValues().addGenericArgumentValue(serviceClass);
        beanDefinition.getConstructorArgumentValues().addGenericArgumentValue((Object)spiService);
        Map<Class<?>, List<Class<?>>> spiInstances = this.loadSpiProperties();
        beanDefinition.getConstructorArgumentValues().addGenericArgumentValue(spiInstances);
        beanDefinition.setAutowireMode(2);
        return beanDefinition;
    }

    private String generateBeanName(BeanDefinition beanDefinition, SpiService spiService) {
        if (spiService != null && StringUtils.hasText((String)spiService.beanName())) {
            return spiService.beanName();
        }
        return beanDefinition.getBeanClassName() + "SpiService";
    }

    private Set<BeanDefinition> scanBeanDefinition(Set<String> basePackages) {
        HashSet<BeanDefinition> consumers = new HashSet<BeanDefinition>();
        CustomClassPathScanningCandidateComponentProvider componentProvider = new CustomClassPathScanningCandidateComponentProvider();
        componentProvider.addIncludeFilter((TypeFilter)new CustomTypeFilter(BaseSpiService.class));
        for (String basePackage : basePackages) {
            Set beanDefinitions = componentProvider.findCandidateComponents(basePackage.replace(".", "/"));
            consumers.addAll(beanDefinitions);
        }
        return consumers;
    }

    private Set<String> obtainScanPackages() {
        String packages = this.environment.getProperty("elitesland.spi.scan-spi-service-packages", "");
        if (StringUtils.hasText((String)packages)) {
            return Arrays.stream(packages.split(",")).filter(StringUtils::hasText).collect(Collectors.toSet());
        }
        if (!AutoConfigurationPackages.has((BeanFactory)this.beanFactory)) {
            return Collections.emptySet();
        }
        return new HashSet<String>(AutoConfigurationPackages.get((BeanFactory)this.beanFactory));
    }

    private Map<Class<?>, List<Class<?>>> loadSpiProperties() {
        Map properties = PropertiesUtil.loadResourceProperties((String)PROPERTIES, null);
        if (properties.isEmpty()) {
            return Collections.emptyMap();
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        HashMap configInstances = new HashMap(128);
        try {
            for (Map.Entry entry : properties.entrySet()) {
                Class<?> spi = classLoader.loadClass((String)entry.getKey());
                List instances = ((List)entry.getValue()).stream().filter(StringUtils::hasText).map(t -> {
                    try {
                        return classLoader.loadClass((String)t);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("\u52a0\u8f7dSPI[" + (String)entry.getKey() + "]\u5b9e\u73b0" + t + "\u5f02\u5e38\uff1a", e);
                    }
                }).collect(Collectors.toList());
                if (instances.isEmpty()) continue;
                configInstances.put(spi, instances);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("\u52a0\u8f7dSPI\u5b9e\u73b0\u5f02\u5e38\uff1a", e);
        }
        return configInstances;
    }

    static class CustomClassPathScanningCandidateComponentProvider
    extends ClassPathScanningCandidateComponentProvider {
        public CustomClassPathScanningCandidateComponentProvider() {
            super(false);
        }

        protected boolean isCandidateComponent(@Nonnull AnnotatedBeanDefinition beanDefinition) {
            return true;
        }
    }

    static class CustomTypeFilter
    extends AssignableTypeFilter {
        public CustomTypeFilter(Class<?> targetType) {
            super(targetType);
        }

        public boolean match(MetadataReader metadataReader, @Nonnull MetadataReaderFactory metadataReaderFactory) throws IOException {
            return metadataReader.getClassMetadata().isInterface() && !metadataReader.getClassMetadata().getClassName().equals(this.getTargetType().getName()) && super.match(metadataReader, metadataReaderFactory);
        }
    }
}

