/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.spi.support;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.spi.support.Source;
import com.elitescloud.boot.spi.support.SpiUtil;
import com.elitescloud.cloudt.common.annotation.context.spi.Spi;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Primary;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.OrderUtils;
import org.springframework.lang.NonNull;

class ProviderWrapper<T> {
    private static final Logger log = LogManager.getLogger(ProviderWrapper.class);
    private final T provider;
    private final Spi spi;
    private final Class<T> clazz;
    private Source source = Source.LIB;
    private int order = 0;
    private boolean primary = false;

    ProviderWrapper(@NonNull T provider, Spi spi, boolean isBean) {
        this.provider = provider;
        this.spi = spi;
        this.clazz = provider.getClass();
        this.analyze(isBean);
    }

    private void analyze(boolean isBean) {
        this.analyzeSource();
        this.analyzeOrder();
        this.analyzePrimary();
        if (!isBean) {
            this.autowiredBean();
        }
    }

    private void analyzeSource() {
        String sourceType;
        String path = Objects.requireNonNull(this.clazz.getResource("/")).toString();
        if (path.contains(sourceType = "/classes/")) {
            this.source = Source.CLASSES;
            return;
        }
    }

    private void analyzeOrder() {
        Integer sort = this.obtainOrderForSpring();
        if (sort != null) {
            this.order = sort;
            return;
        }
        if (this.source == Source.CLASSES) {
            this.order = 1;
        }
    }

    private void analyzePrimary() {
        Primary annoPrimary = SpiUtil.obtainAnnotationSingle(this.clazz, Primary.class);
        this.primary = annoPrimary != null;
    }

    private void autowiredBean() {
        try {
            SpringContextHolder.autowireBean(this.provider);
        }
        catch (Exception e) {
            log.warn("\u88c5\u914dbean\u3010" + this.clazz.getName() + "\u3011\u4f9d\u8d56\u5931\u8d25\uff1a", (Throwable)e);
            throw new IllegalStateException("\u88c5\u914dbean\u5f02\u5e38\uff1a", e);
        }
    }

    private Integer obtainOrderForSpring() {
        Integer sort = OrderUtils.getOrder(this.clazz);
        if (sort != null) {
            return sort;
        }
        if (Ordered.class.isAssignableFrom(this.clazz)) {
            return ((Ordered)this.provider).getOrder();
        }
        return null;
    }

    public Object getProvider() {
        return this.provider;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public Source getSource() {
        return this.source;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }
}

