package com.elitescloud.boot.spi;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * SPI自动化配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/11/10
 */
@ConfigurationProperties(prefix = CloudtSpiProperties.CONFIG_PREFIX)
public class CloudtSpiProperties {
    public static final String CONFIG_PREFIX = "elitesland.spi";

    /**
     * 是否启用SPI Service自动注册
     */
    private Boolean enabled = false;

    /**
     * SpiService所在包路径，默认取启动类所在包，多个则逗号分隔
     */
    private String scanSpiServicePackages;

    /**
     * 默认实例加载策略，优先级最低，低于代码上的配置
     * 配置类必须有空的构造方法
     */
    private String defaultInstanceStrategy;

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getScanSpiServicePackages() {
        return scanSpiServicePackages;
    }

    public void setScanSpiServicePackages(String scanSpiServicePackages) {
        this.scanSpiServicePackages = scanSpiServicePackages;
    }

    public String getDefaultInstanceStrategy() {
        return defaultInstanceStrategy;
    }

    public void setDefaultInstanceStrategy(String defaultInstanceStrategy) {
        this.defaultInstanceStrategy = defaultInstanceStrategy;
    }
}
