/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.spi.support;

import cn.hutool.core.util.ArrayUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.spi.CloudtSpiProperties;
import com.elitescloud.boot.spi.common.BaseSpiService;
import com.elitescloud.boot.spi.common.InstanceStrategy;
import com.elitescloud.boot.spi.common.SpiService;
import com.elitescloud.boot.spi.exception.SpiException;
import com.elitescloud.boot.spi.registrar.SpiServiceFactory;
import com.elitescloud.boot.spi.strategy.DefaultInstanceStrategy;
import com.elitescloud.boot.spi.support.ProviderInstanceHolder;
import com.elitescloud.boot.spi.support.ProviderWrapper;
import com.elitescloud.boot.spi.support.SpiUtil;
import com.elitescloud.cloudt.common.annotation.context.spi.SpiInstance;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.core.annotation.OrderUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SpiServiceProxy<T>
implements InvocationHandler {
    private final SpiService spiService;
    private final Class<T> spiTarget;
    private final List<Class<T>> configSpiInstances;
    private List<InstanceStrategy.InstanceWrapper<T>> instanceList;
    private List<T> instanceDefault;
    private InstanceStrategy instanceStrategy;

    public SpiServiceProxy(@Nullable SpiService spiService, @Nonnull Class<T> spiTarget, @Nullable List<Class<T>> configSpiInstances) {
        this.spiService = spiService;
        this.spiTarget = spiTarget;
        this.configSpiInstances = configSpiInstances;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        List instanceWrapperList;
        List instances;
        if (CollectionUtils.isEmpty(this.instanceList)) {
            try {
                this.loadInstance();
            }
            catch (Exception e) {
                this.instanceList.clear();
                throw e;
            }
        }
        if (this.instanceStrategy == null) {
            this.loadStrategy();
        }
        if (CollectionUtils.isEmpty(instances = this.instanceStrategy.choose(instanceWrapperList = this.instanceList.stream().map(t -> new InstanceStrategy.InstanceWrapper(t.getInstance(), t.isConfigFile(), t.getOrder(), t.getTags())).collect(Collectors.toList())))) {
            instances = this.instanceDefault;
        }
        if (instances.isEmpty()) {
            if (this.spiService != null && this.spiService.throwExceptionOnNoInstance()) {
                throw new SpiException("\u6267\u884c\u5931\u8d25\uff0c" + this.spiTarget.getName() + "\u65e0\u6709\u6548\u5b9e\u4f8b");
            }
            return null;
        }
        Object result = null;
        for (Object instance : instances) {
            result = method.invoke(instance, args);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInstance() {
        Class<SpiServiceFactory> clazz = SpiServiceFactory.class;
        synchronized (SpiServiceFactory.class) {
            if (!CollectionUtils.isEmpty(this.instanceList)) {
                // ** MonitorExit[clazz] (shouldn't be in output)
                return;
            }
            this.instanceList = new ArrayList<InstanceStrategy.InstanceWrapper<T>>(8);
            this.instanceDefault = new ArrayList<T>(8);
            HashSet<String> existsInstances = new HashSet<String>(8);
            Set<String> primaryClassNames = this.obtainPrimaryClassName();
            for (ProviderWrapper<?> providerWrapper : ProviderInstanceHolder.findProvider(this.spiTarget, false)) {
                if (providerWrapper.getProvider() instanceof BaseSpiService) continue;
                InstanceStrategy.InstanceWrapper<Object> instanceWrapper = this.toInstanceWrapper(providerWrapper.getProvider(), false, providerWrapper.getOrder());
                this.instanceList.add(instanceWrapper);
                existsInstances.add(providerWrapper.getClazz().getName());
                if (providerWrapper.isPrimary()) {
                    this.instanceDefault.add(instanceWrapper.getInstance());
                    continue;
                }
                if (!primaryClassNames.contains(providerWrapper.getClazz().getName())) continue;
                this.instanceDefault.add(instanceWrapper.getInstance());
            }
            for (Class clazz2 : this.configSpiInstances) {
                String className = clazz2.getName();
                if (existsInstances.contains(className)) continue;
                InstanceStrategy.InstanceWrapper<T> instanceWrapper = this.toInstanceWrapper(this.buildInstance(clazz2), true, OrderUtils.getOrder((Class)clazz2, (int)0));
                this.instanceList.add(instanceWrapper);
                existsInstances.add(className);
                if (!primaryClassNames.contains(className)) continue;
                this.instanceDefault.add(instanceWrapper.getInstance());
            }
            Assert.state((!this.instanceList.isEmpty() ? 1 : 0) != 0, (String)("\u672a\u627e\u5230" + this.spiTarget.getName() + "\u5b58\u5728\u6709\u6548\u5b9e\u4f8b"));
            if (this.spiService != null) {
                if (this.spiService.primaryRequired()) {
                    Assert.state((!this.instanceDefault.isEmpty() ? 1 : 0) != 0, (String)(this.spiTarget.getName() + "\u672a\u53d1\u73b0\u9ed8\u8ba4\u5b9e\u4f8b"));
                }
                if (this.spiService.primaryUnique()) {
                    Assert.state((this.instanceDefault.size() <= 1 ? 1 : 0) != 0, (String)(this.spiTarget.getName() + "\u53d1\u73b0\u591a\u4e2a\u9ed8\u8ba4\u5b9e\u4f8b"));
                }
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }

    private T buildInstance(Class<T> instanceClass) {
        Object bean = SpringContextHolder.getObjectProvider(instanceClass).getIfAvailable();
        if (bean != null) {
            return (T)bean;
        }
        T instance = null;
        try {
            instance = instanceClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(instanceClass.getName() + "\u7f3a\u5c11\u4e00\u4e2a\u65e0\u53c2\u6784\u9020\u65b9\u6cd5");
        }
        SpringContextHolder.autowireBean(instance);
        return instance;
    }

    private InstanceStrategy.InstanceWrapper<T> toInstanceWrapper(T provider, boolean configFile, int order) {
        HashSet<String> tags = new HashSet<String>();
        SpiInstance spiInstance = SpiUtil.obtainAnnotationSingle(provider.getClass(), SpiInstance.class);
        if (spiInstance != null && ArrayUtil.isNotEmpty((Object[])spiInstance.tags())) {
            tags.addAll(Arrays.asList(spiInstance.tags()));
        }
        return new InstanceStrategy.InstanceWrapper<T>(provider, configFile, order, Collections.unmodifiableSet(tags));
    }

    private void loadStrategy() throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (this.spiService == null) {
            String defaultInstanceStrategy = ((CloudtSpiProperties)SpringContextHolder.getBean(CloudtSpiProperties.class)).getDefaultInstanceStrategy();
            if (StringUtils.hasText((String)defaultInstanceStrategy)) {
                this.instanceStrategy = (InstanceStrategy)Class.forName(defaultInstanceStrategy).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return;
            }
            this.instanceStrategy = new DefaultInstanceStrategy();
            return;
        }
        if (StringUtils.hasText((String)this.spiService.instanceStrategyName())) {
            this.instanceStrategy = (InstanceStrategy)SpringContextHolder.getBean((String)this.spiService.instanceStrategyName(), InstanceStrategy.class);
            return;
        }
        this.instanceStrategy = this.spiService.instanceStrategy().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private Set<String> obtainPrimaryClassName() {
        if (this.spiService == null) {
            return Collections.emptySet();
        }
        HashSet<String> classNames = new HashSet<String>(8);
        if (ArrayUtil.isNotEmpty((Object[])this.spiService.primary())) {
            classNames.addAll(Arrays.asList(this.spiService.primary()));
        }
        if (ArrayUtil.isNotEmpty((Object[])this.spiService.primaryClass())) {
            for (Class<?> clazz : this.spiService.primaryClass()) {
                classNames.add(clazz.getName());
            }
        }
        return classNames;
    }
}

