/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.spi.support;

import cn.hutool.core.util.ArrayUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.spi.common.BaseSpiService;
import com.elitescloud.boot.spi.support.ProviderWrapper;
import com.elitescloud.boot.spi.support.SpiUtil;
import com.elitescloud.cloudt.common.annotation.context.spi.Spi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public final class ProviderInstanceHolder {
    private static final Map<String, List<ProviderWrapper<?>>> CACHE = new ConcurrentHashMap();
    private static final Map<String, Boolean> CACHE_SPRING_LOAD = new ConcurrentHashMap<String, Boolean>();

    private ProviderInstanceHolder() {
    }

    public static <T> List<T> loadProviderInstances(@NonNull Class<T> serviceType, Boolean reload) {
        Assert.notNull(serviceType, (String)"serviceType\u4e3a\u7a7a");
        List<ProviderWrapper<?>> providerWrappers = ProviderInstanceHolder.findProvider(serviceType, reload);
        if (providerWrappers.isEmpty()) {
            return Collections.emptyList();
        }
        return providerWrappers.stream().map(ProviderWrapper::getProvider).collect(Collectors.toList());
    }

    public static <T> Optional<T> loadProviderInstance(@NonNull Class<T> serviceType, Boolean reload) {
        Assert.notNull(serviceType, (String)"serviceType\u4e3a\u7a7a");
        List<ProviderWrapper<?>> providerWrappers = ProviderInstanceHolder.findProvider(serviceType, reload);
        if (providerWrappers.isEmpty()) {
            return Optional.empty();
        }
        for (ProviderWrapper<?> providerWrapper : providerWrappers) {
            if (!providerWrapper.isPrimary()) continue;
            return Optional.of(providerWrapper.getProvider());
        }
        return Optional.of(providerWrappers.get(0).getProvider());
    }

    static <T> List<ProviderWrapper<?>> findProvider(Class<T> serviceType, Boolean reload) {
        boolean loadCache = reload == null || reload == false;
        String serviceName = serviceType.getName();
        Boolean springLoaded = CACHE_SPRING_LOAD.get(serviceName);
        if (springLoaded == null || !springLoaded.booleanValue()) {
            loadCache = false;
        }
        if (loadCache && CACHE.containsKey(serviceName)) {
            return CACHE.get(serviceName);
        }
        List<ProviderWrapper<?>> providers = ProviderInstanceHolder.load(serviceType);
        CACHE.put(serviceName, providers);
        return providers;
    }

    private static <T> List<ProviderWrapper<?>> load(Class<T> serviceType) {
        ArrayList providers = new ArrayList();
        Spi spi = SpiUtil.obtainAnnotationSingle(serviceType, Spi.class);
        HashSet<String> loaded = new HashSet<String>();
        for (Object t : ServiceLoader.load(serviceType)) {
            providers.add(new ProviderWrapper<T>(t, spi, false));
            loaded.add(t.getClass().getName());
        }
        if (SpringContextHolder.initialized()) {
            for (Object t : SpringContextHolder.getObjectProvider(serviceType)) {
                if (loaded.contains(t.getClass().getName()) || t instanceof BaseSpiService) continue;
                providers.add(new ProviderWrapper<Object>(t, spi, true));
                CACHE_SPRING_LOAD.put(serviceType.getName(), true);
            }
        }
        ProviderInstanceHolder.dealSpiPrimary(providers, spi);
        providers.sort(Comparator.comparing(ProviderWrapper::getOrder, Comparator.reverseOrder()));
        return providers;
    }

    private static void dealSpiPrimary(List<ProviderWrapper<?>> providers, Spi spi) {
        if (spi == null || ArrayUtil.isEmpty((Object[])spi.primary()) && ArrayUtil.isEmpty((Object[])spi.primaryClass()) || providers.isEmpty()) {
            return;
        }
        HashSet<String> primaryClassName = new HashSet<String>();
        if (ArrayUtil.isNotEmpty((Object[])spi.primary())) {
            primaryClassName.addAll(Arrays.asList(spi.primary()));
        }
        for (Class clazz : spi.primaryClass()) {
            primaryClassName.add(clazz.getName());
        }
        for (ProviderWrapper providerWrapper : providers) {
            if (!primaryClassName.contains(providerWrapper.getClazz().getName())) continue;
            providerWrapper.setPrimary(true);
            return;
        }
    }
}

