/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.swagger.openapi.service.impl;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationStateEnum;
import com.elitescloud.boot.swagger.openapi.config.OpenApiProperties;
import com.elitescloud.boot.swagger.openapi.model.BusinessObjectInfo;
import com.elitescloud.boot.swagger.openapi.model.BusinessObjectOperationInfo;
import com.elitescloud.boot.swagger.openapi.swagger3.annotations.enums.ParameterIn;
import com.elitescloud.boot.swagger.openapi.swagger3.annotations.parameters.RequestBody;
import com.elitescloud.boot.swagger.openapi.swagger3.core.converter.ModelConverters;
import com.elitescloud.boot.swagger.openapi.swagger3.core.converter.ResolvedSchema;
import com.elitescloud.boot.swagger.openapi.swagger3.core.util.PrimitiveType;
import com.elitescloud.boot.swagger.openapi.swagger3.models.Components;
import com.elitescloud.boot.swagger.openapi.swagger3.models.OpenAPI;
import com.elitescloud.boot.swagger.openapi.swagger3.models.Operation;
import com.elitescloud.boot.swagger.openapi.swagger3.models.PathItem;
import com.elitescloud.boot.swagger.openapi.swagger3.models.Paths;
import com.elitescloud.boot.swagger.openapi.swagger3.models.info.Info;
import com.elitescloud.boot.swagger.openapi.swagger3.models.media.ArraySchema;
import com.elitescloud.boot.swagger.openapi.swagger3.models.media.Content;
import com.elitescloud.boot.swagger.openapi.swagger3.models.media.MapSchema;
import com.elitescloud.boot.swagger.openapi.swagger3.models.media.MediaType;
import com.elitescloud.boot.swagger.openapi.swagger3.models.media.Schema;
import com.elitescloud.boot.swagger.openapi.swagger3.models.parameters.HeaderParameter;
import com.elitescloud.boot.swagger.openapi.swagger3.models.responses.ApiResponse;
import com.elitescloud.boot.swagger.openapi.swagger3.models.responses.ApiResponses;
import com.elitescloud.boot.swagger.openapi.swagger3.models.tags.Tag;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

public class OpenApiServiceUtil {
    private static final Logger log = LoggerFactory.getLogger(OpenApiServiceUtil.class);
    public static final String X_BUSINESS_OBJECT = "x-BusinessObject";
    public static final String X_BUSINESS_OBJECT_OPERATION = "x-BusinessObjectOperation";
    public static final String X_OPEN_API_PROPERTIES = "x-OpenApiProperties";
    public static final String PROJECT_VERSION = "projectVersion";
    public static final String X_PROJECT_VERSION = "x-projectVersion";
    public static final String CLOUDT_BOOT_VERSION = "cloudtBootVersion";
    public static final String X_CLOUDT_BOOT_VERSION = "x-cloudtBootVersion";
    public static final String DEFAULT_TAG = "\u516c\u5171\u63a5\u53e3";
    private static final String X_NEW_DATE = "x-new-date";
    static Map<String, String> parameterDescriptions = new HashMap<String, String>();

    public static void processOperation(Operation operation) {
        if (operation != null) {
            if (operation.getParameters() == null) {
                operation.setParameters(new ArrayList<com.elitescloud.boot.swagger.openapi.swagger3.models.parameters.Parameter>());
            }
            for (Map.Entry<String, String> entry : parameterDescriptions.entrySet()) {
                String paramName = entry.getKey();
                String paramDescription = entry.getValue();
                com.elitescloud.boot.swagger.openapi.swagger3.models.parameters.Parameter header = new HeaderParameter().name(paramName).description(paramDescription).required(true);
                operation.getParameters().add(header);
            }
        }
    }

    public static void setInitInfo(OpenAPI openAPI, OpenApiProperties openApiProperties) {
        Paths paths = new Paths();
        Tag tag = new Tag().name(DEFAULT_TAG).description("\u672a\u4e1a\u52a1\u5bf9\u8c61\u6ce8\u89e3\u8fdb\u884c\u5206\u7ec4\u7684\u63a5\u53e3\uff0c\u516c\u5171\u63a5\u53e3\u6ca1\u6709\u5177\u4f53\u4e1a\u52a1\u5bf9\u8c61\u3002");
        openAPI.addTagsItem(tag);
        for (OperationStateEnum state : OperationStateEnum.values()) {
            openAPI.addTagsItem(new Tag().name(state.getDescription()).description(state.name()));
        }
        StringBuffer titleBuffer = new StringBuffer();
        titleBuffer.append(openApiProperties.getProject()).append(":").append(openApiProperties.getProjectName()).append(":").append(openApiProperties.getEnv()).append(":").append(openApiProperties.getEnvName()).append(":").append(openApiProperties.getService()).append(":").append(openApiProperties.getServiceName());
        Info info = new Info().title(titleBuffer.toString()).description(openApiProperties.getDescription());
        info.addExtension(X_OPEN_API_PROPERTIES, openApiProperties);
        info.addExtension(X_NEW_DATE, LocalDateTime.now());
        info.setVersion(openApiProperties.getProjectVersion());
        info.setSummary(openApiProperties.getCloudtBootVersion());
        info.addExtension(X_PROJECT_VERSION, openApiProperties.getProjectVersion());
        info.addExtension(X_CLOUDT_BOOT_VERSION, openApiProperties.getCloudtBootVersion());
        openAPI.setInfo(info);
        openAPI.setComponents(new Components());
        openAPI.setPaths(paths);
    }

    public static void processController(Class<?> controllerClass, OpenAPI openAPI, Paths paths) {
        RequestMapping requestMapping = controllerClass.getAnnotation(RequestMapping.class);
        if (requestMapping == null) {
            log.error("RequestMapping annotation not found on {}", (Object)controllerClass.getName());
            return;
        }
        String basePath = Arrays.stream(requestMapping.value()).findFirst().orElse("");
        BusinessObject businessObject = controllerClass.getAnnotation(BusinessObject.class);
        for (Method method : controllerClass.getDeclaredMethods()) {
            if (!OpenApiServiceUtil.isAnnotationMapping(method).booleanValue()) continue;
            Type returnType = method.getGenericReturnType();
            ResolvedSchema resolvedSchema = ModelConverters.getInstance().readAllAsResolvedSchema(returnType);
            Schema mehtodReturnSchema = OpenApiServiceUtil.processMehtodRetuntComponentsGetSchema(openAPI, resolvedSchema);
            Operation operation = OpenApiServiceUtil.createOperationFromApiOperation(openAPI, businessObject, method);
            for (Parameter parameter : method.getParameters()) {
                OpenApiServiceUtil.processRequestBodyParameter(parameter, operation, openAPI);
                com.elitescloud.boot.swagger.openapi.swagger3.models.parameters.Parameter parameterV3 = OpenApiServiceUtil.createParameterForApi(parameter);
                if (parameterV3 == null) continue;
                operation.addParametersItem(parameterV3);
            }
            OpenApiServiceUtil.processReturnParameter(operation, mehtodReturnSchema);
            String path = basePath + OpenApiServiceUtil.getMethodPath(method);
            OpenApiServiceUtil.addOperationToPathItem(path, method, operation, paths);
        }
    }

    public static Schema processMehtodRetuntComponentsGetSchema(OpenAPI openAPI, ResolvedSchema resolvedSchema) {
        Schema mehtodReturnSchemaNew = null;
        if (resolvedSchema != null && resolvedSchema.schema != null) {
            mehtodReturnSchemaNew = resolvedSchema.schema;
        }
        if (resolvedSchema != null && resolvedSchema.referencedSchemas != null && resolvedSchema.referencedSchemas.size() > 0) {
            for (Map.Entry<String, Schema> entry : resolvedSchema.referencedSchemas.entrySet()) {
                String name = entry.getKey();
                Schema schema = entry.getValue();
                openAPI.getComponents().addSchemas(name, schema);
                if (mehtodReturnSchemaNew != null) continue;
                mehtodReturnSchemaNew = schema;
            }
        }
        return mehtodReturnSchemaNew;
    }

    public static void processReturnParameter(Operation operation, Schema mehtodReturnSchema) {
        ApiResponse apiResponse = new ApiResponse();
        apiResponse.content(new Content().addMediaType("application/json", new MediaType().schema(mehtodReturnSchema)));
        ApiResponses apiResponses = new ApiResponses();
        apiResponses.addApiResponse("200", apiResponse);
        operation.setResponses(apiResponses);
    }

    public static Operation createOperationFromApiOperation(OpenAPI openAPI, BusinessObject businessObject, Method method) {
        ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
        Operation operation = new Operation();
        operation.setSummary(apiOperation == null ? "\u7a7a" : (StringUtils.isBlank((CharSequence)apiOperation.value()) ? "\u7a7a" : apiOperation.value()));
        operation.setDescription(apiOperation == null ? "\u7a7a" : (StringUtils.isBlank((CharSequence)apiOperation.notes()) ? "\u7a7a" : apiOperation.notes()));
        if (businessObject != null) {
            BusinessObjectInfo businessObjectInfo = BusinessObjectInfo.getBusinessObjectInfo(businessObject);
            operation.addExtension(X_BUSINESS_OBJECT, businessObjectInfo);
            openAPI.addTagsItem(new Tag().name(businessObject.businessType()));
            operation.addTagsItem(businessObject.businessType());
            operation.setDeprecated(businessObject.enabled());
            BusinessObjectOperation businessObjectOperation = method.getAnnotation(BusinessObjectOperation.class);
            BusinessObjectOperationInfo businessObjectOperationInfo = BusinessObjectOperationInfo.getBusinessObjectOperationInfo(businessObjectOperation);
            if (businessObjectOperationInfo != null) {
                operation.addExtension(X_BUSINESS_OBJECT_OPERATION, businessObjectOperationInfo);
                operation.operationId(method.toString());
                StringBuffer summary = new StringBuffer();
                summary.append(operation.getSummary()).append("-").append(businessObjectOperationInfo.getOperationStateEnum().getDescription());
                operation.setSummary(summary.toString());
                operation.addTagsItem(businessObjectOperationInfo.getOperationStateEnum().getDescription());
                operation.addTagsItem(businessObjectOperationInfo.getOperationScopeEnum().getDescription());
            } else {
                operation.addTagsItem(DEFAULT_TAG);
            }
        } else {
            operation.addTagsItem(DEFAULT_TAG);
        }
        openAPI.addTagsItem(new Tag().name("\u5de5\u7a0b\u7248\u672c" + openAPI.getInfo().getVersion() + "-\u67b6\u6784\u7248\u672c" + openAPI.getInfo().getSummary()));
        operation.addTagsItem("\u5de5\u7a0b\u7248\u672c" + openAPI.getInfo().getVersion() + "-\u67b6\u6784\u7248\u672c" + openAPI.getInfo().getSummary());
        return operation;
    }

    public static void processRequestBodyParameter(Parameter parameter, Operation operation, OpenAPI openAPI) {
        RequestBody requestBodyAnnotation = parameter.getAnnotation(RequestBody.class);
        if (requestBodyAnnotation != null) {
            Schema returnSchema;
            Class<?> paramType = parameter.getType();
            if (paramType.isArray() || Collection.class.isAssignableFrom(paramType)) {
                Type parameterizedType = parameter.getParameterizedType();
                ResolvedSchema resolvedSchema = ModelConverters.getInstance().readAllAsResolvedSchema(parameterizedType);
                if (resolvedSchema == null) {
                    return;
                }
                Map<String, Schema> schemaMap = resolvedSchema.referencedSchemas;
                Schema schema = schemaMap.get(OpenApiServiceUtil.getGenericTypeClass(parameterizedType).getSimpleName());
                returnSchema = new ArraySchema().name(paramType.getName()).items(schema).description(parameter.getParameterizedType().getTypeName());
                for (Map.Entry entry : schemaMap.entrySet()) {
                    String name = (String)entry.getKey();
                    Schema schema2 = (Schema)entry.getValue();
                    openAPI.getComponents().addSchemas(name, schema2);
                }
            } else if (Map.class.isAssignableFrom(paramType)) {
                returnSchema = new MapSchema();
                returnSchema.setAdditionalProperties(true);
                returnSchema.description(parameter.getParameterizedType().getTypeName());
                returnSchema.name(paramType.getSimpleName());
            } else {
                ResolvedSchema resolvedSchema = ModelConverters.getInstance().readAllAsResolvedSchema(paramType);
                if (resolvedSchema == null) {
                    return;
                }
                Map<String, Schema> schemaMap = resolvedSchema.referencedSchemas;
                if (schemaMap == null) {
                    return;
                }
                if (parameter.getParameterizedType() instanceof ParameterizedType) {
                    log.error(" \u4e0d\u662f\u6570\u7ec4\u6709\u6cdb\u578b");
                }
                returnSchema = schemaMap.get(paramType.getSimpleName());
                for (Map.Entry entry : schemaMap.entrySet()) {
                    String name = (String)entry.getKey();
                    Schema schema = (Schema)entry.getValue();
                    openAPI.getComponents().addSchemas(name, schema);
                }
            }
            com.elitescloud.boot.swagger.openapi.swagger3.models.parameters.RequestBody requestBody = new com.elitescloud.boot.swagger.openapi.swagger3.models.parameters.RequestBody();
            MediaType mediaType = new MediaType();
            Content content = new Content();
            content.addMediaType("application/json", mediaType.schema(returnSchema));
            requestBody.content(content);
            operation.setRequestBody(requestBody);
        }
    }

    public static Class<?> getGenericTypeClass(Type type) {
        Type firstTypeArgument;
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        if (type instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length > 0 && (firstTypeArgument = actualTypeArguments[0]) instanceof Class) {
            return (Class)firstTypeArgument;
        }
        return null;
    }

    public static com.elitescloud.boot.swagger.openapi.swagger3.models.parameters.Parameter createParameterForApi(Parameter parameter) {
        com.elitescloud.boot.swagger.openapi.swagger3.models.parameters.Parameter parameterV3 = new com.elitescloud.boot.swagger.openapi.swagger3.models.parameters.Parameter();
        String annotationParameterType = OpenApiServiceUtil.getAnnotationParameterType(parameter);
        if (annotationParameterType == null) {
            return null;
        }
        ResolvedSchema schemaResolved = ModelConverters.getInstance().readAllAsResolvedSchema(parameter.getParameterizedType());
        PrimitiveType pType = PrimitiveType.fromType(parameter.getParameterizedType());
        Schema schema = new Schema();
        if (schemaResolved == null) {
            schema.setName(pType.getCommonName());
            schema.setTitle(pType.name());
            schema.setType(pType.name());
            schema = pType.createProperty();
        } else {
            schema = schemaResolved.schema;
        }
        parameterV3.setName(parameter.getName());
        parameterV3.setSchema(schema);
        parameterV3.setDescription(parameter.getName());
        parameterV3.setRequired(true);
        parameterV3.setIn(annotationParameterType);
        return parameterV3;
    }

    public static String getAnnotationParameterType(Parameter parameter) {
        if (parameter.isAnnotationPresent(PathVariable.class)) {
            return ParameterIn.PATH.toString();
        }
        if (parameter.isAnnotationPresent(RequestParam.class)) {
            return ParameterIn.QUERY.toString();
        }
        if (parameter.isAnnotationPresent(RequestHeader.class)) {
            return ParameterIn.HEADER.toString();
        }
        if (parameter.isAnnotationPresent(CookieValue.class)) {
            return ParameterIn.COOKIE.toString();
        }
        return null;
    }

    public static void addOperationToPathItem(String path, Method method, Operation operation, Paths paths) {
        PathItem pathItem = (PathItem)paths.get(path);
        if (pathItem == null) {
            pathItem = new PathItem();
        }
        OpenApiServiceUtil.setOperationBasedOnHttpMethod(method, pathItem, operation);
        paths.addPathItem(path, pathItem);
    }

    public static String getMethodPath(Method method) {
        GetMapping getMapping = method.getAnnotation(GetMapping.class);
        if (getMapping != null && getMapping.value().length > 0) {
            return getMapping.value()[0];
        }
        PostMapping postMapping = method.getAnnotation(PostMapping.class);
        if (postMapping != null && postMapping.value().length > 0) {
            return postMapping.value()[0];
        }
        PutMapping putMapping = method.getAnnotation(PutMapping.class);
        if (putMapping != null && putMapping.value().length > 0) {
            return putMapping.value()[0];
        }
        DeleteMapping deleteMapping = method.getAnnotation(DeleteMapping.class);
        if (deleteMapping != null && deleteMapping.value().length > 0) {
            return deleteMapping.value()[0];
        }
        return "";
    }

    public static void setOperationBasedOnHttpMethod(Method method, PathItem pathItem, Operation operation) {
        if (method.isAnnotationPresent(GetMapping.class)) {
            pathItem.setGet(operation);
            OpenApiServiceUtil.processOperation(operation);
        } else if (method.isAnnotationPresent(PostMapping.class)) {
            pathItem.setPost(operation);
            OpenApiServiceUtil.processOperation(operation);
        } else if (method.isAnnotationPresent(PutMapping.class)) {
            pathItem.setPut(operation);
            OpenApiServiceUtil.processOperation(operation);
        } else if (method.isAnnotationPresent(DeleteMapping.class)) {
            pathItem.setDelete(operation);
            OpenApiServiceUtil.processOperation(operation);
        }
    }

    public static Boolean isAnnotationMapping(Method method) {
        if (method.isAnnotationPresent(GetMapping.class) || method.isAnnotationPresent(PostMapping.class) || method.isAnnotationPresent(PutMapping.class) || method.isAnnotationPresent(DeleteMapping.class)) {
            return true;
        }
        return false;
    }

    static {
        parameterDescriptions.put("Authorization", "\u8ba4\u8bc1\u4ee4\u724c");
        parameterDescriptions.put("X-Tenant-Code", "\u79df\u6237\u7f16\u7801:\u64cd\u4f5c\u8005\u5982\u679c\u662f\u7b2c\u4e09\u65b9\u5ba2\u6237\u7aef\uff08\u6216\u8005\u5176\u5b83\u672a\u767b\u5f55\u7528\u6237\u7684\u60c5\u51b5\u4e0b\uff09\uff0c\u9700\u8981\u6307\u5b9a\u8bbf\u95ee\u67d0\u79df\u6237\u4e0b\u7684\u6570\u636e\u65f6\u4f20\u9012");
        parameterDescriptions.put("X-Tenant-Id", "\u540c\u7406X-Tenant-Code\uff0c\u76ee\u524d\u5728\u7528\u7684\u4e1a\u52a1\u573a\u666f\uff1a\u5de5\u4f5c\u6d41\u56de\u8c03\u4e1a\u52a1\u65f6\u4f20\u9012\u7684\u79df\u6237ID\u3002");
        parameterDescriptions.put("menuCode", "\u83dc\u5355\u7f16\u7801\uff1a\u7528\u4e8e\u6570\u636e\u6743\u9650\uff0c\u4f20\u9012\u8bf7\u6c42API\u662f\u90a3\u4e2a\u83dc\u5355");
    }
}

