package com.elitescloud.boot.swagger.openapi.model;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 业务对象参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/15
 */
@Getter
@Setter
public class BusinessObjectParamInfo implements Serializable {
    private static final long serialVersionUID = -932659485638554406L;

    /**
     * 类名
     */
    private String className;

    /**
     * 表名
     */
    private String tableName;

    /**
     * 表注释
     */
    private String tableComment;

    /**
     * 参数列表
     */
    private List<Param> paramList;

    @Getter
    @Setter
    public static class Param implements Serializable {
        private static final long serialVersionUID = 5490886846850181463L;

        /**
         * 字段名
         */
        private String fieldName;

        /**
         * 列名
         */
        private String columnName;

        /**
         * 字段注释
         */
        private String fieldComment;

        /**
         * 字段类型
         */
        private String javaType;
    }
}
