package com.elitescloud.boot.swagger.openapi.swagger3.annotations.info;

import com.elitescloud.boot.swagger.openapi.swagger3.annotations.OpenAPI31;
import com.elitescloud.boot.swagger.openapi.swagger3.annotations.OpenAPIDefinition;
import com.elitescloud.boot.swagger.openapi.swagger3.annotations.extensions.Extension;

import java.lang.annotation.*;

/**
 * The annotation may be used in {@link OpenAPIDefinition#info()} to populate the Info section of the OpenAPI document.
 *
 * @see <a target="_new" href="https://github.com/OAI/OpenAPI-Specification/blob/3.0.1/versions/3.0.1.md#infoObject">Info (OpenAPI specification)</a>
 * @see <a target="_new" href="https://github.com/OAI/OpenAPI-Specification/blob/3.1.0/versions/3.1.0.md#infoObject">Info (OpenAPI specification)</a>
 * @see OpenAPIDefinition
 **/
@Target({ElementType.ANNOTATION_TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
public @interface Info {
    /**
     * The title of the application.
     *
     * @return the application's title
     **/
    String title() default "";

    /**
     * A short description of the application. CommonMark syntax can be used for rich text representation.
     *
     * @return the application's description
     **/
    String description() default "";

    /**
     * A URL to the Terms of Service for the API. Must be in the format of a URL.
     *
     * @return the application's terms of service
     **/
    String termsOfService() default "";

    /**
     * The contact information for the exposed API.
     *
     * @return a contact for the application
     **/
    Contact contact() default @Contact();

    /**
     * The license information for the exposed API.
     *
     * @return the license of the application
     **/
    License license() default @License();

    /**
     * The version of the API definition.
     *
     * @return the application's version
     **/
    String version() default "";

    /**
     * The list of optional extensions
     *
     * @return an optional array of extensions
     */
    Extension[] extensions() default {};

    /**
     * A short API summary.
     *
     * @since 2.2.12 / OpenAPI 3.1
     * @return API summary
     **/
    @OpenAPI31
    String summary() default "";

}
