/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.swagger.openapi.service.impl;

import com.elitescloud.boot.swagger.openapi.config.OpenApiProperties;
import com.elitescloud.boot.swagger.openapi.service.impl.OpenApiServiceUtil;
import com.elitescloud.boot.swagger.openapi.swagger3.models.OpenAPI;
import com.elitescloud.boot.swagger.openapi.swagger3.models.info.Info;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.RestController;

public class OpenApiService {
    private static final Logger log = LoggerFactory.getLogger(OpenApiService.class);
    private final ApplicationContext applicationContext;
    private final OpenApiProperties openApiProperties;

    public OpenApiService(ApplicationContext applicationContext, OpenApiProperties openApiProperties) {
        this.applicationContext = applicationContext;
        this.openApiProperties = openApiProperties;
    }

    public OpenAPI generateOpenApi() {
        OpenAPI openApi = new OpenAPI();
        OpenApiServiceUtil.setInitInfo(openApi, this.openApiProperties);
        Map controllers = this.applicationContext.getBeansWithAnnotation(RestController.class);
        for (Object controller : controllers.values()) {
            this.processController(openApi, controller);
        }
        return openApi;
    }

    public OpenAPI generateOpenApi(Object ... controllers) {
        OpenAPI openApi = new OpenAPI();
        OpenApiServiceUtil.setInitInfo(openApi, this.openApiProperties);
        if (controllers != null) {
            for (Object controller : controllers) {
                this.processController(openApi, controller);
            }
        }
        return openApi;
    }

    public Info getOpenApiInfo() {
        return OpenApiServiceUtil.getInfo(this.openApiProperties);
    }

    private void processController(OpenAPI openApi, Object controller) {
        Class controllerClass = AopProxyUtils.ultimateTargetClass((Object)controller);
        OpenApiServiceUtil.processController(controllerClass, openApi, openApi.getPaths());
    }
}

