package com.elitescloud.boot.swagger.openapi.config;

import com.elitescloud.boot.swagger.common.BaseSwaggerConfig;
import com.github.xiaoymin.knife4j.spring.extension.OpenApiExtensionResolver;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import springfox.documentation.spring.web.plugins.Docket;

/**
 * Swagger2全局配置
 *
 * @author Michael Li
 * @date 2018-11-08
 */
@ConditionalOnProperty(prefix = "knife4j", name = "enable", havingValue = "true")
public class OpenApiSwaggerConfig extends BaseSwaggerConfig {

    public OpenApiSwaggerConfig(OpenApiExtensionResolver openApiExtensionResolver, ServerProperties serverProperties) {
        super(openApiExtensionResolver, serverProperties);
    }

    @Bean
    public Docket cloudtOpenAPiApi() {
        return createDocket("CloudtOpenAPI", "com.elitescloud.boot.swagger.openapi.contrlloer");
    }
}
