package com.elitescloud.boot.swagger.openapi.contrlloer;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationStateEnum;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.swagger.openapi.service.impl.OpenApiService;
import com.elitescloud.boot.swagger.openapi.service.impl.OpenApiServiceUtil;
import com.elitescloud.boot.swagger.openapi.swagger3.core.util.Json;
import com.elitescloud.boot.swagger.openapi.swagger3.core.util.Json31;
import com.elitescloud.boot.swagger.openapi.swagger3.models.info.Info;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.boot.swagger.openapi.swagger3.models.OpenAPI;


import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.io.FileWriter;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-01-02 11:12
 */
@Slf4j
@Api(value = "平台API管理", tags = {"平台API管理"})
@RequestMapping("/sys/openapi")
@BusinessObject(businessType = "SysOpenApi:开放API")
@ResponseBody
public class OpenApiController {

    private final OpenApiService generateOpenApi;

    public OpenApiController(OpenApiService generateOpenApi) {
        this.generateOpenApi = generateOpenApi;
    }
    @GetMapping("/download/json")
    @ApiOperation("下载平台的OpenAPI JSON")
    @BusinessObjectOperation(operationType = OperationTypeEnum.DOWNLOAD,
            operationDescription = "下载平台的OpenAPI JSON")
    public ResponseEntity<ByteArrayResource> downloadJsonFile() throws IOException {
        OpenAPI api = this.generateOpenApi.generateOpenApi();
        String jsonPretty = Json.pretty(api);
        byte[] jsonBytes = jsonPretty.getBytes(StandardCharsets.UTF_8);
        ByteArrayResource resource = new ByteArrayResource(jsonBytes);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        // 使用 LocalDateTime 替代 LocalDate
        LocalDateTime currentDateTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy_MM_dd_HH_mm_ss");
        String dateString = currentDateTime.format(formatter);

        String encodedFileName = URLEncoder.encode(api.getInfo().getTitle() + dateString, StandardCharsets.UTF_8.toString());
        headers.setContentDispositionFormData("attachment", encodedFileName + ".json");

        return ResponseEntity.ok()
                .headers(headers)
                .contentLength(jsonBytes.length)
                .body(resource);
    }
    @GetMapping("/getOpenApiInfo")
    @ApiOperation("返回实例openApi info")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT,
            operationDescription = "返回实例openApi info")
    public ApiResult<Info> getOpenApiInfo()   {
        return ApiResult.ok(generateOpenApi.getOpenApiInfo());
    }

    @GetMapping("/get/json")
    @ApiOperation("返回平台的OpenAPI JSON")
    @BusinessObjectOperation(operationType = OperationTypeEnum.DOWNLOAD,
            operationDescription = "返回平台的OpenAPI JSON")
    public ApiResult<String> getJson() throws IOException {
        OpenAPI api = this.generateOpenApi.generateOpenApi();
        String jsonPretty = Json.pretty(api);
        return  ApiResult.ok(jsonPretty);
    }
    @PostMapping("/test/localJson")
    @ApiOperation(value = "测试接口：输出本地JSON", notes = "测试输出本地JSON")
    @BusinessObjectOperation(operationType = OperationTypeEnum.ELSE,
            operationDescription = "测试输出本地JSON",operationStateEnum = OperationStateEnum.TESTING)
    public ApiResult<String> queryApi() {
        OpenAPI api = generateOpenApi.generateOpenApi();
//        log.info("OpenAPI---{}", api);
        String json = Json31.pretty(api);
      //  log.info("Json31---{}", json);
      //  String yaml = Yaml31.pretty(api);
    //    log.info("Yaml31---{}", yaml);
        String   jsonPretty = Json.pretty(api);
        //   log.info("Json---{}", json);
        // String  yamlPretty = Yaml.pretty(api);
        //  log.info("Yaml---{}", yaml);
        try {
            // 保存 JSON 数据
            FileWriter jsonWriter = new FileWriter("api.json");
            jsonWriter.write(json);
            jsonWriter.close();
            // 保存 YAML 数据
//            FileWriter yamlWriter = new FileWriter("api.yaml");
//            yamlWriter.write(yaml);
//            yamlWriter.close();
            // 保存格式化的 JSON 数据
            FileWriter jsonPrettyWriter = new FileWriter("api_pretty.json");
            jsonPrettyWriter.write(jsonPretty);
            jsonPrettyWriter.close();
            // 保存格式化的 YAML 数据
//            FileWriter yamlPrettyWriter = new FileWriter("api_pretty.yaml");
//            yamlPrettyWriter.write(yamlPretty);
//            yamlPrettyWriter.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return ApiResult.ok(json);
    }


}
