/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.swagger.openapi.contrlloer;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationStateEnum;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.swagger.openapi.service.impl.OpenApIService;
import com.elitescloud.boot.swagger.openapi.swaageV3.core.util.Json;
import com.elitescloud.boot.swagger.openapi.swaageV3.core.util.Json31;
import com.elitescloud.boot.swagger.openapi.swaageV3.models.OpenAPI;
import com.elitescloud.cloudt.common.base.ApiResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u5e73\u53f0API\u7ba1\u7406", tags={"\u5e73\u53f0API\u7ba1\u7406"})
@RequestMapping(value={"/sys/openapi"})
@BusinessObject(businessType="SysOpenApi:\u5f00\u653eAPI")
@ResponseBody
public class OpenApiController {
    private static final Logger log = LoggerFactory.getLogger(OpenApiController.class);
    private final OpenApIService generateOpenApi;

    public OpenApiController(OpenApIService generateOpenApi) {
        this.generateOpenApi = generateOpenApi;
    }

    @GetMapping(value={"/download/json"})
    @ApiOperation(value="\u4e0b\u8f7d\u5e73\u53f0\u7684OpenAPI JSON")
    @BusinessObjectOperation(operationType=OperationTypeEnum.DOWNLOAD, operationDescription="\u4e0b\u8f7d\u5e73\u53f0\u7684OpenAPI JSON")
    public ResponseEntity<ByteArrayResource> downloadJsonFile() throws IOException {
        OpenAPI api = this.generateOpenApi.generateOpenApi();
        String jsonPretty = Json.pretty(api);
        byte[] jsonBytes = jsonPretty.getBytes(StandardCharsets.UTF_8);
        ByteArrayResource resource = new ByteArrayResource(jsonBytes);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        LocalDateTime currentDateTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy_MM_dd_HH_mm_ss");
        String dateString = currentDateTime.format(formatter);
        String encodedFileName = URLEncoder.encode(api.getInfo().getTitle() + dateString, StandardCharsets.UTF_8.toString());
        headers.setContentDispositionFormData("attachment", encodedFileName + ".json");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength((long)jsonBytes.length).body((Object)resource);
    }

    @GetMapping(value={"/get/json"})
    @ApiOperation(value="\u8fd4\u56de\u5e73\u53f0\u7684OpenAPI JSON")
    @BusinessObjectOperation(operationType=OperationTypeEnum.DOWNLOAD, operationDescription="\u8fd4\u56de\u5e73\u53f0\u7684OpenAPI JSON")
    public ApiResult<String> getJson() throws IOException {
        OpenAPI api = this.generateOpenApi.generateOpenApi();
        String jsonPretty = Json.pretty(api);
        return ApiResult.ok((Object)jsonPretty);
    }

    @PostMapping(value={"/test/localJson"})
    @ApiOperation(value="\u6d4b\u8bd5\u63a5\u53e3\uff1a\u8f93\u51fa\u672c\u5730JSON", notes="\u6d4b\u8bd5\u8f93\u51fa\u672c\u5730JSON")
    @BusinessObjectOperation(operationType=OperationTypeEnum.ELSE, operationDescription="\u6d4b\u8bd5\u8f93\u51fa\u672c\u5730JSON", operationStateEnum=OperationStateEnum.TESTING)
    public ApiResult<String> queryApi() {
        OpenAPI api = this.generateOpenApi.generateOpenApi();
        String json = Json31.pretty(api);
        String jsonPretty = Json.pretty(api);
        try {
            FileWriter jsonWriter = new FileWriter("api.json");
            jsonWriter.write(json);
            jsonWriter.close();
            FileWriter jsonPrettyWriter = new FileWriter("api_pretty.json");
            jsonPrettyWriter.write(jsonPretty);
            jsonPrettyWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ApiResult.ok((Object)json);
    }
}

