/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.swagger.openapi.swaageV3.core.util;

import com.elitescloud.boot.swagger.openapi.swaageV3.core.util.Json;
import com.elitescloud.boot.swagger.openapi.swaageV3.core.util.Json31;
import com.elitescloud.boot.swagger.openapi.swaageV3.models.media.ArraySchema;
import com.elitescloud.boot.swagger.openapi.swaageV3.models.media.BooleanSchema;
import com.elitescloud.boot.swagger.openapi.swaageV3.models.media.ComposedSchema;
import com.elitescloud.boot.swagger.openapi.swaageV3.models.media.DateSchema;
import com.elitescloud.boot.swagger.openapi.swaageV3.models.media.DateTimeSchema;
import com.elitescloud.boot.swagger.openapi.swaageV3.models.media.EmailSchema;
import com.elitescloud.boot.swagger.openapi.swaageV3.models.media.IntegerSchema;
import com.elitescloud.boot.swagger.openapi.swaageV3.models.media.JsonSchema;
import com.elitescloud.boot.swagger.openapi.swaageV3.models.media.MapSchema;
import com.elitescloud.boot.swagger.openapi.swaageV3.models.media.NumberSchema;
import com.elitescloud.boot.swagger.openapi.swaageV3.models.media.ObjectSchema;
import com.elitescloud.boot.swagger.openapi.swaageV3.models.media.PasswordSchema;
import com.elitescloud.boot.swagger.openapi.swaageV3.models.media.Schema;
import com.elitescloud.boot.swagger.openapi.swaageV3.models.media.StringSchema;
import com.elitescloud.boot.swagger.openapi.swaageV3.models.media.UUIDSchema;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ModelDeserializer
extends JsonDeserializer<Schema> {
    protected boolean openapi31 = false;

    public Schema deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String format;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Schema schema = null;
        if (this.openapi31) {
            schema = this.deserializeJsonSchema(node);
            return schema;
        }
        if (node.isBoolean()) {
            return new Schema().booleanSchemaValue(node.booleanValue());
        }
        List<String> composed = Arrays.asList("allOf", "anyOf", "oneOf");
        for (String field : composed) {
            if (node.get(field) == null) continue;
            return (Schema)Json.mapper().convertValue((Object)node, ComposedSchema.class);
        }
        JsonNode type = node.get("type");
        String string = format = node.get("format") == null ? "" : node.get("format").textValue();
        if (type != null && "array".equals(((TextNode)type).textValue())) {
            schema = (Schema)Json.mapper().convertValue((Object)node, ArraySchema.class);
        } else if (type != null) {
            if (type.textValue().equals("integer")) {
                schema = (Schema)Json.mapper().convertValue((Object)node, IntegerSchema.class);
                if (StringUtils.isBlank((CharSequence)format)) {
                    schema.setFormat(null);
                }
            } else if (type.textValue().equals("number")) {
                schema = (Schema)Json.mapper().convertValue((Object)node, NumberSchema.class);
            } else if (type.textValue().equals("boolean")) {
                schema = (Schema)Json.mapper().convertValue((Object)node, BooleanSchema.class);
            } else if (type.textValue().equals("string")) {
                schema = "date".equals(format) ? (Schema)Json.mapper().convertValue((Object)node, DateSchema.class) : ("date-time".equals(format) ? (Schema)Json.mapper().convertValue((Object)node, DateTimeSchema.class) : ("email".equals(format) ? (Schema)Json.mapper().convertValue((Object)node, EmailSchema.class) : ("password".equals(format) ? (Schema)Json.mapper().convertValue((Object)node, PasswordSchema.class) : ("uuid".equals(format) ? (Schema)Json.mapper().convertValue((Object)node, UUIDSchema.class) : (Schema)Json.mapper().convertValue((Object)node, StringSchema.class)))));
            } else if (type.textValue().equals("object")) {
                schema = this.deserializeObjectSchema(node);
            }
        } else {
            schema = node.get("$ref") != null ? new Schema().$ref(node.get("$ref").asText()) : this.deserializeObjectSchema(node);
        }
        return schema;
    }

    private Schema deserializeObjectSchema(JsonNode node) {
        JsonNode additionalProperties = node.get("additionalProperties");
        Schema schema = null;
        if (additionalProperties != null) {
            if (additionalProperties.isBoolean()) {
                Boolean additionalPropsBoolean = (Boolean)Json.mapper().convertValue((Object)additionalProperties, Boolean.class);
                ((ObjectNode)node).remove("additionalProperties");
                schema = additionalPropsBoolean != false ? (Schema)Json.mapper().convertValue((Object)node, MapSchema.class) : (Schema)Json.mapper().convertValue((Object)node, ObjectSchema.class);
                schema.setAdditionalProperties(additionalPropsBoolean);
            } else {
                Schema innerSchema = (Schema)Json.mapper().convertValue((Object)additionalProperties, Schema.class);
                ((ObjectNode)node).remove("additionalProperties");
                MapSchema ms = (MapSchema)Json.mapper().convertValue((Object)node, MapSchema.class);
                ms.setAdditionalProperties(innerSchema);
                schema = ms;
            }
        } else {
            schema = (Schema)Json.mapper().convertValue((Object)node, ObjectSchema.class);
        }
        if (schema != null) {
            schema.jsonSchema(Json31.jsonSchemaAsMap(node));
        }
        return schema;
    }

    private Schema deserializeJsonSchema(JsonNode node) {
        Schema schema;
        block12: {
            if (node.isBoolean()) {
                return new Schema().booleanSchemaValue(node.booleanValue());
            }
            JsonNode additionalProperties = node.get("additionalProperties");
            JsonNode type = node.get("type");
            schema = null;
            if (type != null || additionalProperties != null) {
                if (type != null) {
                    ((ObjectNode)node).remove("type");
                }
                if (additionalProperties != null) {
                    ((ObjectNode)node).remove("additionalProperties");
                }
                schema = (Schema)Json31.mapper().convertValue((Object)node, JsonSchema.class);
                if (type instanceof TextNode) {
                    schema.types(new LinkedHashSet<String>(Arrays.asList(type.textValue())));
                } else if (type instanceof ArrayNode) {
                    LinkedHashSet<String> types = new LinkedHashSet<String>();
                    ((ArrayNode)type).elements().forEachRemaining(n -> types.add(n.textValue()));
                    schema.types(types);
                }
                if (additionalProperties != null) {
                    try {
                        if (additionalProperties.isBoolean()) {
                            schema.setAdditionalProperties(additionalProperties.booleanValue());
                            break block12;
                        }
                        Schema innerSchema = this.deserializeJsonSchema(additionalProperties);
                        schema.setAdditionalProperties(innerSchema);
                    }
                    catch (Exception e) {
                        Boolean additionalPropsBoolean = (Boolean)Json31.mapper().convertValue((Object)additionalProperties, Boolean.class);
                        schema.setAdditionalProperties(additionalPropsBoolean);
                    }
                }
            } else {
                schema = (Schema)Json31.mapper().convertValue((Object)node, JsonSchema.class);
            }
        }
        return schema;
    }
}

