package com.elitescloud.boot.swagger.openapi.model;

import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.BusinessParmObjectTypeEnum;
import com.elitescloud.boot.common.annotation.businessobject.OperationScopeEnum;
import com.elitescloud.boot.common.annotation.businessobject.OperationStateEnum;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.io.Serializable;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-01-02 17:06
 */
@Slf4j
@Data
public class BusinessObjectOperationInfo implements Serializable {

    private boolean enabled;

    //业务操作的业务对象关联，如果不填写默认关联类上@BusinessObject内容
    private String businessObjectType;

    //业务入参对象的取值名称-当前版本不支持
    private BusinessParmObjectTypeEnum businessParamObjectType;
    //暂无用-业务参数取值key
    private String businessParamValueKey;
    //操作编码
    private String operationCode;
    //操作类型枚举
    private OperationTypeEnum operationType;

    //操作描述
    private String operationDescription;

    //业务参数，用于业务查询
    private String businessParam;

    //操作范围
    private OperationScopeEnum operationScopeEnum;
    //操作状态
    private OperationStateEnum operationStateEnum;

    //是否记录日志
    private boolean logEnabled;

    //是否记录入参
    private boolean argsJsonEnabled;
    //是否记录出参
    private boolean resultJsonEnabled;

    private boolean allowRepeatRequest;
    private int repeatIntervalMillis;
    private boolean dataPermissionEnabled;
    private String[] permissionFields;

    public static BusinessObjectOperationInfo getBusinessObjectOperationInfo(
            BusinessObjectOperation businessObjectOperation) {
        if (businessObjectOperation != null) {
            BusinessObjectOperationInfo businessObjectOperationInfo = new BusinessObjectOperationInfo();
            businessObjectOperationInfo.setEnabled(businessObjectOperation.enabled());
            businessObjectOperationInfo.setBusinessObjectType(businessObjectOperation.businessObjectType());
            businessObjectOperationInfo.setOperationCode(businessObjectOperation.operationCode());
            businessObjectOperationInfo.setBusinessParamObjectType(businessObjectOperation.businessParamObjectType());
            businessObjectOperationInfo.setBusinessParamValueKey(businessObjectOperation.businessParamValueKey());
            businessObjectOperationInfo.setOperationType(businessObjectOperation.operationType());
            businessObjectOperationInfo.setOperationDescription(businessObjectOperation.operationDescription());
            businessObjectOperationInfo.setBusinessParam(businessObjectOperation.businessParam());
            businessObjectOperationInfo.setOperationScopeEnum(businessObjectOperation.operationScopeEnum());
            businessObjectOperationInfo.setOperationStateEnum(businessObjectOperation.operationStateEnum());
            businessObjectOperationInfo.setLogEnabled(businessObjectOperation.logEnabled());
            businessObjectOperationInfo.setArgsJsonEnabled(businessObjectOperation.argsJsonEnabled());
            businessObjectOperationInfo.setResultJsonEnabled(businessObjectOperation.argsJsonEnabled());

            businessObjectOperationInfo.setRepeatIntervalMillis(businessObjectOperation.repeatIntervalMillis());
            businessObjectOperationInfo.setAllowRepeatRequest(businessObjectOperation.allowRepeatRequest());
            businessObjectOperationInfo.setDataPermissionEnabled(businessObjectOperation.dataPermissionEnabled());
            businessObjectOperationInfo.setPermissionFields(businessObjectOperation.permissionFields());

            return businessObjectOperationInfo;
        }
        return null;
    }
}
