package com.elitescloud.boot.swagger.openapi.swagger3.core.jackson.mixin;

import com.elitescloud.boot.swagger.openapi.swagger3.models.Paths;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.elitescloud.boot.swagger.openapi.swagger3.core.jackson.PathsSerializer;

import java.util.Map;

public abstract class OpenAPI31Mixin {

    @JsonAnyGetter
    public abstract Map<String, Object> getExtensions();

    @JsonAnySetter
    public abstract void addExtension(String name, Object value);

    @JsonSerialize(using = PathsSerializer.class)
    public abstract Paths getPaths();

}
