package com.elitescloud.boot.swagger;

import com.elitescloud.boot.swagger.openapi.common.OpenApiRpcClient;
import com.elitescloud.boot.swagger.openapi.client.OpenApiRpcClientProvider;
import com.elitescloud.boot.swagger.openapi.config.OpenApiProperties;
import com.elitescloud.boot.swagger.openapi.config.OpenApiSwaggerConfig;
import com.elitescloud.boot.swagger.openapi.contrlloer.OpenApiController;
import com.elitescloud.boot.swagger.openapi.service.impl.OpenApiService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

/**
 * Swagger自动化配置.
 *
 * @author Kaiser（wang shao）
 * @date 3/14/2023
 */
@Slf4j
@ConditionalOnProperty(prefix = OpenApiProperties.CONFIG_PREFIX, name = "enabled", havingValue = "true", matchIfMissing = true)
@EnableConfigurationProperties({OpenApiProperties.class})
@Import(OpenApiSwaggerConfig.class)
class CloudtOpenApiAutoConfiguration {

    @Bean
    public OpenApiService openApiService(ApplicationContext applicationContext, OpenApiProperties openApiProperties) {
        return new OpenApiService(applicationContext, openApiProperties);
    }

    @Bean
    public OpenApiController openApiController(OpenApiService openApiService) {
        return new OpenApiController(openApiService);
    }

    @Bean
    public OpenApiRpcClientProvider openApiRpcClient(OpenApiService openApiService) {
        return new OpenApiRpcClientProvider(openApiService);
    }
}
