/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.swagger.common;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.net.NetUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.util.CloudtBootUtil;
import com.github.xiaoymin.knife4j.spring.extension.OpenApiExtensionResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Import;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;

@EnableSwagger2WebMvc
@Import(value={BeanValidatorPluginsConfiguration.class})
public abstract class BaseSwaggerConfig {
    @Value(value="${swagger.host:#{''}}")
    protected String host;
    @Value(value="${swagger.base-path:#{'/'}}")
    protected String basePath;
    @Value(value="${swagger.title:#{''}}")
    protected String title;
    @Value(value="${swagger.description:#{''}}")
    protected String description;
    @Value(value="${swagger.url:#{''}}")
    protected String url;
    @Value(value="${swagger.contact.name:#{''}}")
    protected String contactName;
    @Value(value="${swagger.contact.url:#{''}}")
    protected String contactUrl;
    @Value(value="${swagger.contact.email:#{''}}")
    protected String contactEmail;
    @Value(value="${swagger.exclude.rpc:#{true}}")
    protected Boolean excludeRpc;
    protected final OpenApiExtensionResolver openApiExtensionResolver;
    protected final ServerProperties serverProperties;

    protected BaseSwaggerConfig(OpenApiExtensionResolver openApiExtensionResolver, ServerProperties serverProperties) {
        this.openApiExtensionResolver = openApiExtensionResolver;
        this.serverProperties = serverProperties;
    }

    protected Docket createDocket(@NonNull String groupName, String ... controllerPackage) {
        return this.createDocket(groupName, (List<Parameter>)null, controllerPackage);
    }

    protected Docket createDocket(@NonNull String groupName, List<Parameter> globalParameters, String ... controllerPackage) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(this.parameterGlobal("Authorization", 0, "\u7528\u6237token"));
        if (CollUtil.isNotEmpty(globalParameters)) {
            parameters.addAll(globalParameters);
        }
        parameters.add(this.parameterGlobal("menuCode", 1, "\u83dc\u5355\u7f16\u7801"));
        parameters.add(this.parameterGlobal("X-Cloudt-BusinessObject", 2, "\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801"));
        parameters.add(this.parameterGlobal("X-Cloudt-BusinessOperation", 3, "\u4e1a\u52a1\u5bf9\u8c61\u7684\u64cd\u4f5c\u7f16\u7801"));
        try {
            Class.forName("com.elitescloud.boot.tenant.client.common.TenantClient");
            Parameter paramTenantId = new ParameterBuilder().name("X-Tenant-Code").parameterType("header").modelRef((ModelReference)new ModelRef("string")).order(1).description("\u79df\u6237\u7f16\u7801").build();
            parameters.add(paramTenantId);
        }
        catch (Exception paramTenantId) {
            // empty catch block
        }
        Assert.notEmpty((Object[])controllerPackage, (String)"swagger\u914d\u7f6e\u5931\u8d25\uff0c\u7f3a\u5c11controller\u5305\u8def\u5f84");
        Predicate predicate = null;
        for (String p : controllerPackage) {
            predicate = predicate == null ? RequestHandlerSelectors.basePackage((String)p) : predicate.or(RequestHandlerSelectors.basePackage((String)p));
        }
        return new Docket(DocumentationType.SWAGGER_2).groupName(groupName).apiInfo(this.apiInfo(groupName)).select().apis(predicate).paths(this.pathSelector()).build().host(this.host).pathMapping(this.basePath).globalOperationParameters(parameters).extensions(this.openApiExtensionResolver.buildExtensions(groupName));
    }

    protected Predicate<String> pathSelector() {
        if (this.excludeRpc()) {
            return p -> !p.startsWith("/rpc");
        }
        return PathSelectors.any();
    }

    protected boolean excludeRpc() {
        return this.excludeRpc == null || this.excludeRpc != false;
    }

    protected ApiInfo apiInfo(String desc) {
        return new ApiInfoBuilder().title(this.title).description(this.description + "\u3010" + desc + "\u3011").termsOfServiceUrl(this.getServiceUrl()).contact(new Contact(this.contactName, this.contactUrl, this.contactEmail)).version(CloudtBootUtil.getProjectVersion()).build();
    }

    protected Parameter parameterGlobal(String name, Integer order, String description) {
        return new ParameterBuilder().name(name).parameterType("header").modelRef((ModelReference)new ModelRef("String")).order(order.intValue()).description(description).build();
    }

    protected String getServiceUrl() {
        if (CharSequenceUtil.isNotBlank((CharSequence)this.url)) {
            return this.url;
        }
        int port = Objects.requireNonNullElse(this.serverProperties.getPort(), 8080);
        String contextPath = CharSequenceUtil.blankToDefault((CharSequence)this.serverProperties.getServlet().getContextPath(), (String)"");
        return "http://" + this.getIp() + ":" + port + contextPath;
    }

    protected String getIp() {
        if (this.serverProperties.getAddress() != null) {
            return this.serverProperties.getAddress().getHostAddress();
        }
        return (String)ObjectUtil.defaultIfNull((Object)NetUtil.getLocalhost().getHostAddress(), (Object)"127.0.0.1");
    }
}

