package com.elitescloud.boot.swagger.openapi.swagger3.annotations.media;

import java.lang.annotation.*;

import static java.lang.annotation.ElementType.*;

/**
 * The annotation may be used to define properties for an Object Schema
 *
 * @see Schema
 *
 * @since 2.1.8
 **/
@Target({FIELD, METHOD, PARAMETER, TYPE, ANNOTATION_TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Repeatable(SchemaProperties.class)
public @interface SchemaProperty {
    /**
     * The name.
     *
     * @return the name
     **/
    String name() default "";

    /**
     * The schema of the property.
     *
     * @return the schema
     **/
    Schema schema() default @Schema();

    /**
     * The schema of the array.
     *
     * @return the schema of the array
     */
    ArraySchema array() default @ArraySchema();

}
