package com.elitescloud.boot.swagger.openapi.model;

import com.elitescloud.boot.common.annotation.BusinessObject;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.io.Serializable;
import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-01-02 17:19
 */
@Slf4j
@Data
public class BusinessObjectInfo implements Serializable {
    private static final long serialVersionUID = -465990391527734355L;

    /**业务对象启用**/
    private Boolean enabled;
    /**业务对象类型**/
    private String businessType;
    /**业务对象描述**/
    private String businessDescription;
    private String domain;
    private List<BusinessObjectParamInfo> paramInfoList;
    private String[] refBusinessObjectOperations;

    public static BusinessObjectInfo getBusinessObjectInfo(BusinessObject businessObject){
        BusinessObjectInfo businessObjectInfo = new BusinessObjectInfo();
        businessObjectInfo.setEnabled(businessObject.enabled());
        businessObjectInfo.setBusinessType(businessObject.businessType());
        businessObjectInfo.setBusinessDescription(businessObject.businessDescription());
        businessObjectInfo.setDomain(businessObject.businessObjectDomain());
        businessObjectInfo.setRefBusinessObjectOperations(businessObject.refBusinessObjectOperations());
        return businessObjectInfo;
    }
}
