package com.elitescloud.boot.swagger.openapi.common.spi;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import org.springframework.web.bind.annotation.RequestMethod;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;

/**
 * OpenAPI加载策略SPI.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/8
 */
public interface OpenApiLoadStrategySPI {

    /**
     * 是否启用
     *
     * @return 默认启用
     */
    default boolean enabled() {
        return true;
    }

    /**
     * 加载所有OpenAPI的类
     *
     * @return 类
     */
    List<Class<?>> load();

    /**
     * 是否支持解析
     *
     * @param clazz 待及诶的类
     * @return 是否支持解析
     */
    default boolean support(Class<?> clazz) {
        return true;
    }

    /**
     * 解析OpenAPI信息
     *
     * @param clazz 待解析的class
     * @return OpenApi信息
     */
    List<OpenApiInfo> analyze(Class<?> clazz);

    /**
     * 是否为请求头
     *
     * @param parameter 参数
     * @return 是否为请求头参数
     */
    boolean isRequestBody(Parameter parameter);

    public static class OpenApiInfo {

        /**
         * openApi方法
         */
        private final Method method;

        /**
         * 请求方法
         */
        private final RequestMethod requestMethod;

        /**
         * 请求地址
         */
        private final String uri;

        /**
         * 业务对象信息
         */
        private BusinessObject businessObject;

        /**
         * 业务操作
         */
        private BusinessObjectOperation businessObjectOperation;

        /**
         * 业务对象类型
         * <p>
         * 优先从{@link #businessObject}取值
         */
        private String businessObjectType;

        /**
         * 业务操作编码
         * <p>
         * 优先从{@link #businessObjectOperation}取值
         */
        private String businessOperationCode;

        /**
         * 操作名称
         */
        private String operationDescription;

        /**
         * 操作描述
         */
        private String detail;

        /**
         * 操作类型
         */
        private OperationTypeEnum operationType;

        /**
         * 数据权限支持
         */
        private boolean dataPermissionEnabled;

        /**
         * 是否启用自动字段权限过滤
         */
        private boolean fieldPermissionAutoFilter;

        /**
         * 权限规则同步关联的业务对象操作编码
         */
        private String permissionRef;

        public OpenApiInfo(Method method, RequestMethod requestMethod, String uri) {
            this.method = method;
            this.requestMethod = requestMethod;
            this.uri = uri;
        }

        public Method getMethod() {
            return method;
        }

        public RequestMethod getRequestMethod() {
            return requestMethod;
        }

        public String getUri() {
            return uri;
        }

        public BusinessObject getBusinessObject() {
            return businessObject;
        }

        public void setBusinessObject(BusinessObject businessObject) {
            this.businessObject = businessObject;
        }

        public String getBusinessObjectType() {
            return businessObjectType;
        }

        public void setBusinessObjectType(String businessObjectType) {
            this.businessObjectType = businessObjectType;
        }

        public BusinessObjectOperation getBusinessObjectOperation() {
            return businessObjectOperation;
        }

        public void setBusinessObjectOperation(BusinessObjectOperation businessObjectOperation) {
            this.businessObjectOperation = businessObjectOperation;
        }

        public String getBusinessOperationCode() {
            return businessOperationCode;
        }

        public void setBusinessOperationCode(String businessOperationCode) {
            this.businessOperationCode = businessOperationCode;
        }

        public String getOperationDescription() {
            return operationDescription;
        }

        public void setOperationDescription(String operationDescription) {
            this.operationDescription = operationDescription;
        }

        public String getDetail() {
            return detail;
        }

        public void setDetail(String detail) {
            this.detail = detail;
        }

        public OperationTypeEnum getOperationType() {
            return operationType;
        }

        public void setOperationType(OperationTypeEnum operationType) {
            this.operationType = operationType;
        }

        public boolean isDataPermissionEnabled() {
            return dataPermissionEnabled;
        }

        public void setDataPermissionEnabled(boolean dataPermissionEnabled) {
            this.dataPermissionEnabled = dataPermissionEnabled;
        }

        public boolean isFieldPermissionAutoFilter() {
            return fieldPermissionAutoFilter;
        }

        public void setFieldPermissionAutoFilter(boolean fieldPermissionAutoFilter) {
            this.fieldPermissionAutoFilter = fieldPermissionAutoFilter;
        }

        public String getPermissionRef() {
            return permissionRef;
        }

        public void setPermissionRef(String permissionRef) {
            this.permissionRef = permissionRef;
        }
    }
}
