package com.elitescloud.boot.swagger.openapi.config;

import com.elitescloud.boot.util.CloudtBootUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @author : chen.niu
 * @description : 读取openapi配置
 * @date : 2024-01-16 10:11
 */
@ConfigurationProperties(prefix = OpenApiProperties.CONFIG_PREFIX)
public class OpenApiProperties {
    public static final String CONFIG_PREFIX = "elitesland.openapi";

    public static final String DEFAULT = "未配置";

    /**
     * 是否启用
     */
    private Boolean enabled = true;

    /**
     * 项目编码
     */
    private String project = DEFAULT;

    /**
     * 项目名称
     */
    private String projectName = DEFAULT;

    /**
     * 环境编码
     */
    private String env = DEFAULT;

    /**
     * 环境名称
     */
    private String envName = DEFAULT;

    /**
     * 服务编码
     */
    private String service = DEFAULT;

    /**
     * 服务名称
     */
    private String serviceName = DEFAULT;

    private String description=DEFAULT;

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getProjectVersion() {
        return CloudtBootUtil.getProjectVersion();
    }

    public String getCloudtBootVersion() {
        return CloudtBootUtil.getVersion();
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }


    public String getProject() {
        return project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getEnv() {
        return env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getEnvName() {
        return envName;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    public String getService() {
        return service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getServiceName() {
        return serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}