package com.elitescloud.boot.swagger.openapi.model;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 业务对象参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/15
 */
@Getter
@Setter
public class BusinessObjectParamInfo implements Serializable {
    private static final long serialVersionUID = -932659485638554406L;

    /**
     * 类名
     */
    private String className;

    /**
     * 表名
     */
    private String tableName;

    /**
     * 表注释
     */
    private String tableComment;

    /**
     * 参数列表
     */
    private List<Param> paramList;

    @Getter
    @Setter
    public static class Param implements Serializable {
        private static final long serialVersionUID = 5490886846850181463L;

        /**
         * 字段名
         */
        private String fieldName;

        /**
         * 列名
         */
        private String columnName;

        /**
         * 字段注释
         */
        private String fieldComment;

        /**
         * 字段类型
         */
        private String javaType;

        /**
         * 是否单值
         */
        private boolean single;

        /**
         * 是否枚举类
         */
        private boolean enumeration;

        /**
         * 枚举值类型
         */
        private String enumType;

        /**
         * 关联的业务对象标识
         */
        private String relatedBusinessObject;

        /**
         * 关联的业务对象字段
         */
        private String relatedField;

        /**
         * 限制值
         */
        private String[] values;

        /**
         * 账户类型
         */
        private String userType;

        /**
         * 是否应于数据权限过滤
         */
        private boolean dataPermissionEnabled;

        /**
         * 是否应于字段权限过滤
         */
        private boolean fieldPermissionEnabled;

        /**
         * 是否为基础字段
         */
        private boolean baseField;

        /**
         * 是否过期
         */
        private boolean deprecated;
    }
}
