package com.elitescloud.boot.swagger.openapi.swagger3.annotations.info;

import com.elitescloud.boot.swagger.openapi.swagger3.annotations.OpenAPI31;
import com.elitescloud.boot.swagger.openapi.swagger3.annotations.OpenAPIDefinition;
import com.elitescloud.boot.swagger.openapi.swagger3.annotations.extensions.Extension;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * The annotation may be used in {@link Info#license()} to define a license for the OpenAPI spec.
 *
 * @see <a target="_new" href="https://github.com/OAI/OpenAPI-Specification/blob/3.0.1/versions/3.0.1.md#licenseObject">License (OpenAPI 3.0 pecification)</a>
 * @see <a target="_new" href="https://github.com/OAI/OpenAPI-Specification/blob/3.1.0/versions/3.1.0.md#licenseObject">License (OpenAPI 3.1 specification)</a>
 * @see OpenAPIDefinition
 * @see Info
 **/
@Target({})
@Retention(RetentionPolicy.RUNTIME)
public @interface License {
    /**
     * The license name used for the API.
     *
     * @return the name of the license
     **/
    String name() default "";

    /**
     * A URL to the license used for the API. MUST be in the format of a URL.
     *
     * @return URL to the license
     **/
    String url() default "";

    /**
     * The list of optional extensions
     *
     * @return an optional array of extensions
     */
    Extension[] extensions() default {};

    /**
     * An identifier for a License instance.
     *
     * @since 2.2.12 / OpenAPI 3.1
     * @return the identifier of the license
     **/
    @OpenAPI31
    String identifier() default "";

}
