package com.elitescloud.boot.swagger.openapi.swagger3.core.jackson.mixin;

import com.elitescloud.boot.swagger.openapi.swagger3.models.PathItem;
import com.elitescloud.boot.swagger.openapi.swagger3.models.callbacks.Callback;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.elitescloud.boot.swagger.openapi.swagger3.core.jackson.CallbackSerializer;

import java.util.Map;

public abstract class ComponentsMixin {

    @JsonAnyGetter
    public abstract Map<String, Object> getExtensions();

    @JsonAnySetter
    public abstract void addExtension(String name, Object value);

    @JsonSerialize(contentUsing = CallbackSerializer.class)
    public abstract Map<String, Callback> getCallbacks();

    @JsonIgnore
    public abstract Map<String, PathItem> getPathItems();

}
