package com.elitescloud.boot.swagger.openapi.swagger3.annotations.extensions;

import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.*;

/**
 * Container for repeatable {@link Extension} annotation
 *
 * @see Extension
 */
@Target({FIELD, METHOD, PARAMETER, TYPE, ANNOTATION_TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
public @interface Extensions {
    /**
     * An array of Extension annotations
     *
     * @return the array of the extensions
     **/
    Extension[] value() default {};

}
