package com.elitescloud.boot.swagger.openapi.swagger3.core.jackson;

import com.elitescloud.boot.swagger.openapi.swagger3.models.media.MediaType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;

import java.io.IOException;

public class MediaTypeSerializer extends JsonSerializer<MediaType> implements ResolvableSerializer {

    private JsonSerializer<Object> defaultSerializer;

    public MediaTypeSerializer(JsonSerializer<Object> serializer) {
        defaultSerializer = serializer;
    }

    @Override
    public void resolve(SerializerProvider serializerProvider) throws JsonMappingException {
        if (defaultSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer) defaultSerializer).resolve(serializerProvider);
        }
    }

    @Override
    public void serialize(
            MediaType value, JsonGenerator jgen, SerializerProvider provider)
            throws IOException {

        if (value.getExampleSetFlag() && value.getExample() == null) {
            jgen.writeStartObject();
            defaultSerializer.unwrappingSerializer(null).serialize(value, jgen, provider);
            jgen.writeNullField("example");
            jgen.writeEndObject();
        } else {
            defaultSerializer.serialize(value, jgen, provider);
        }
    }
}


