package com.elitescloud.boot.swagger.openapi.client;

import com.elitescloud.boot.swagger.openapi.common.OpenApiRpcClient;
import com.elitescloud.boot.swagger.openapi.service.impl.OpenApiService;
import com.elitescloud.boot.swagger.openapi.swagger3.core.util.Json;
import com.elitescloud.boot.swagger.openapi.swagger3.models.OpenAPI;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/4
 */
@Slf4j
@ResponseBody
@RequestMapping(value = OpenApiRpcClient.URI)
public class OpenApiRpcProvider implements OpenApiRpcClient {

    private final OpenApiService openApiService;

    public OpenApiRpcProvider(OpenApiService openApiService) {
        this.openApiService = openApiService;
    }

    @Override
    public ApiResult<OpenAPI> getOpenApi() {
        OpenAPI openApi = null;
        try {
            openApi = openApiService.generateOpenApi();
        } catch (Exception e) {
            log.error("生成OpenApi异常：", e);
            return ApiResult.fail("OpenApi信息生成失败");
        }
        return ApiResult.ok(openApi);
    }

    @Override
    public ApiResult<String> getOpenApiJson() {
        var openApi = this.getOpenApi();
        if (openApi.isFailed()) {
            return ApiResult.fail(openApi.getMsg());
        }

        // 序列化
        String openApiJson = null;
        try {
            openApiJson = JSONUtil.toJsonString(openApi, true);
        } catch (Exception e) {
            log.error("OpenApi序列化异常：", e);
            return ApiResult.fail("OpenApi序列化失败");
        }
        return ApiResult.ok(openApiJson);
    }

    @Override
    public ApiResult<String> getOpenApiJsonPretty() {
        var openApi = this.getOpenApi();
        if (openApi.isFailed()) {
            return ApiResult.fail(openApi.getMsg());
        }

        // 序列化
        String openApiJson = null;
        try {
            openApiJson = Json.pretty(openApi);
        } catch (Exception e) {
            log.error("OpenApi序列化异常：", e);
            return ApiResult.fail("OpenApi序列化失败");
        }
        return ApiResult.ok(openApiJson);
    }
}
