package com.elitescloud.boot.swagger.openapi.model;

import com.elitescloud.boot.common.annotation.BusinessObject;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.io.Serializable;
import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-01-02 17:19
 */
@Slf4j
@Data
public class BusinessObjectInfo implements Serializable {
    private static final long serialVersionUID = -465990391527734355L;

    private Boolean enabled;
    private String businessType;
    private String businessDescription;
    private String domain;
    private List<BusinessObjectParamInfo> paramInfoList;
    private String[] refBusinessObjectOperations;
    /**
     * 是否是公共资源
     */
    private Boolean publicResource;

    /**
     * 是否支持租户
     */
    private Boolean supportTenant;

    public static BusinessObjectInfo getBusinessObjectInfo(BusinessObject businessObject){
        BusinessObjectInfo businessObjectInfo = new BusinessObjectInfo();
        businessObjectInfo.setEnabled(businessObject.enabled());
        businessObjectInfo.setBusinessType(businessObject.businessType());
        businessObjectInfo.setBusinessDescription(businessObject.businessDescription());
        businessObjectInfo.setDomain(businessObject.businessObjectDomain());
        businessObjectInfo.setRefBusinessObjectOperations(businessObject.refBusinessObjectOperations());
        businessObjectInfo.setPublicResource(businessObject.publicResource());
        businessObjectInfo.setSupportTenant(businessObject.supportTenant());
        return businessObjectInfo;
    }
}
