/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.swagger.openapi.client;

import com.elitescloud.boot.swagger.openapi.common.OpenApiRpcClient;
import com.elitescloud.boot.swagger.openapi.service.impl.OpenApiService;
import com.elitescloud.boot.swagger.openapi.swagger3.core.util.Json;
import com.elitescloud.boot.swagger.openapi.swagger3.models.OpenAPI;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@ResponseBody
@RequestMapping(value={"/rpc/cloudt/swagger/openapi"})
public class OpenApiRpcProvider
implements OpenApiRpcClient {
    private static final Logger log = LoggerFactory.getLogger(OpenApiRpcProvider.class);
    private final OpenApiService openApiService;

    public OpenApiRpcProvider(OpenApiService openApiService) {
        this.openApiService = openApiService;
    }

    @Override
    public ApiResult<OpenAPI> getOpenApi() {
        OpenAPI openApi = null;
        try {
            openApi = this.openApiService.generateOpenApi();
        }
        catch (Exception e) {
            log.error("\u751f\u6210OpenApi\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)"OpenApi\u4fe1\u606f\u751f\u6210\u5931\u8d25");
        }
        return ApiResult.ok((Object)openApi);
    }

    @Override
    public ApiResult<String> getOpenApiJson() {
        ApiResult<OpenAPI> openApi = this.getOpenApi();
        if (openApi.isFailed()) {
            return ApiResult.fail((String)openApi.getMsg());
        }
        String openApiJson = null;
        try {
            openApiJson = JSONUtil.toJsonString(openApi, (boolean)true);
        }
        catch (Exception e) {
            log.error("OpenApi\u5e8f\u5217\u5316\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)"OpenApi\u5e8f\u5217\u5316\u5931\u8d25");
        }
        return ApiResult.ok((Object)openApiJson);
    }

    @Override
    public ApiResult<String> getOpenApiJsonPretty() {
        ApiResult<OpenAPI> openApi = this.getOpenApi();
        if (openApi.isFailed()) {
            return ApiResult.fail((String)openApi.getMsg());
        }
        String openApiJson = null;
        try {
            openApiJson = Json.pretty(openApi);
        }
        catch (Exception e) {
            log.error("OpenApi\u5e8f\u5217\u5316\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)"OpenApi\u5e8f\u5217\u5316\u5931\u8d25");
        }
        return ApiResult.ok((Object)openApiJson);
    }
}

