package com.elitescloud.boot.swagger.openapi.common;

import com.elitescloud.boot.constant.OpenFeignConstant;
import com.elitescloud.boot.swagger.openapi.swagger3.models.OpenAPI;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.web.bind.annotation.GetMapping;

/**
 * RPC客户端.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/4
 */
public interface OpenApiRpcClient {
    String URI = OpenFeignConstant.URI_PREFIX + "/cloudt/swagger/openapi";

    /**
     * 获取OpenAPI信息.
     *
     * @return OpenApi对象
     */
    @GetMapping(value = "/get")
    ApiResult<OpenAPI> getOpenApi();

    /**
     * 获取OpenAPI的json信息.
     * <p>
     * 使用Spring提供的工具类进行序列化
     *
     * @return OpenAPI的json信息
     */
    @GetMapping(value = "/getJson")
    ApiResult<String> getOpenApiJson();

    /**
     * 获取OpenAPI的json信息.
     * <p>
     * 使用OpenApi提供的工具类进行序列化
     *
     * @return OpenAPI的json信息
     */
    @GetMapping(value = "/getJsonPretty")
    ApiResult<String> getOpenApiJsonPretty();
}
