/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.swagger;

import com.elitescloud.boot.swagger.openapi.client.OpenApiRpcProvider;
import com.elitescloud.boot.swagger.openapi.config.OpenApiProperties;
import com.elitescloud.boot.swagger.openapi.config.OpenApiSwaggerConfig;
import com.elitescloud.boot.swagger.openapi.contrlloer.OpenApiController;
import com.elitescloud.boot.swagger.openapi.service.impl.OpenApiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@ConditionalOnProperty(prefix="elitesland.openapi", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={OpenApiProperties.class})
@Import(value={OpenApiSwaggerConfig.class})
class CloudtOpenApiAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CloudtOpenApiAutoConfiguration.class);

    CloudtOpenApiAutoConfiguration() {
    }

    @Bean
    public OpenApiService openApiService(ApplicationContext applicationContext, OpenApiProperties openApiProperties) {
        return new OpenApiService(applicationContext, openApiProperties);
    }

    @Bean
    public OpenApiController openApiController(OpenApiService openApiService) {
        return new OpenApiController(openApiService);
    }

    @Bean
    public OpenApiRpcProvider openApiRpcClient(OpenApiService openApiService) {
        return new OpenApiRpcProvider(openApiService);
    }
}

